/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20DefaultCasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.RequestValidatorTestUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuth20DefaultOAuthCodeFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuth")
@TestPropertySource(properties={"cas.authn.oauth.session-replication.replicate-sessions=false"})
public class OAuth20AuthorizationCodeGrantTypeTokenRequestValidatorTests {

    @Nested
    public class DefaultTests
    extends AbstractOAuth20Tests {
        private OAuth20Code supportingServiceTicket;
        private OAuth20Code nonSupportingServiceTicket;
        private OAuth20Code promiscuousServiceTicket;
        @Autowired
        @Qualifier(value="oauthAuthorizationCodeGrantTypeTokenRequestValidator")
        private OAuth20TokenRequestValidator validator;

        @BeforeEach
        public void before() throws Exception {
            OAuthRegisteredService supportingService = RequestValidatorTestUtils.getService("https://google.com", "supporting", "supporting", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
            OAuthRegisteredService nonSupportingService = RequestValidatorTestUtils.getService("https://example.com", "nonsupporting", "nonsupporting", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
            OAuthRegisteredService promiscuousService = RequestValidatorTestUtils.getPromiscuousService("https://another.example.com", "promiscuous", "promiscuous", "secret");
            this.supportingServiceTicket = this.registerTicket(supportingService);
            this.nonSupportingServiceTicket = this.registerTicket(nonSupportingService);
            this.promiscuousServiceTicket = this.registerTicket(promiscuousService);
            this.servicesManager.deleteAll();
            this.servicesManager.save(new RegisteredService[]{supportingService, nonSupportingService, promiscuousService});
        }

        @Test
        public void verifyBadToken() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", "https://google.com");
            request.setParameter("code", "UnknownToken");
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        }

        @Test
        public void verifyBadService() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", "https://google.com");
            request.setParameter("code", this.nonSupportingServiceTicket.getId());
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        }

        @Test
        public void verifyBadRequest() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", "https://google.com");
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        }

        @Test
        public void verifyUnknownCodeRevokesPreviousAccessTokens() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("casuser");
            OAuth20AccessToken at = this.addAccessToken(principal, this.addRegisteredService());
            OAuth20Code code = (OAuth20Code)this.ticketRegistry.getTicket(at.getToken(), OAuth20Code.class);
            Assertions.assertNotNull((Object)code);
            code.markTicketExpired();
            request.setParameter("code", code.getId());
            profile.setId("promiscuous");
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", "https://another.example.com");
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            Assertions.assertNull((Object)this.ticketRegistry.getTicket(at.getToken()));
        }

        @Test
        public void verifyOperation() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", "https://google.com");
            request.setParameter("code", this.supportingServiceTicket.getId());
            Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            request.setParameter("grant_type", "unsupported");
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            request.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.getType());
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("code", this.nonSupportingServiceTicket.getId());
            request.setParameter("redirect_uri", "https://example.com");
            profile.setId("nonsupporting");
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            request.setParameter("code", this.promiscuousServiceTicket.getId());
            profile.setId("promiscuous");
            request.setParameter("redirect_uri", "https://another.example.com");
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        }

        private OAuth20Code registerTicket(OAuthRegisteredService service) throws Exception {
            OAuth20DefaultCasAuthenticationBuilder builder = new OAuth20DefaultCasAuthenticationBuilder(PrincipalFactoryUtils.newPrincipalFactory(), (ServiceFactory)new WebApplicationServiceFactory(), (OAuth20ProfileScopeToAttributesFilter)new DefaultOAuth20ProfileScopeToAttributesFilter(), this.oauthRequestParameterResolver, this.casProperties);
            Service oauthCasAuthenticationBuilderService = builder.buildService(service, null, false);
            ExpirationPolicyBuilder expirationPolicy = new ExpirationPolicyBuilder(){
                private static final long serialVersionUID = 3911344031977989503L;

                public ExpirationPolicy buildTicketExpirationPolicy() {
                    return new OAuth20CodeExpirationPolicy(1L, 60L);
                }
            };
            OAuth20Code oauthCode = new OAuth20DefaultOAuthCodeFactory((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy, (ServicesManager)Mockito.mock(ServicesManager.class), CipherExecutor.noOpOfStringToString()).create(oauthCasAuthenticationBuilderService, RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new HashSet(), null, null, "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
            this.ticketRegistry.addTicket((Ticket)oauthCode);
            return oauthCode;
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oauth.code.remove-related-access-tokens=true"})
    public class RemovingInvalidTokenTests
    extends AbstractOAuth20Tests {
        @Autowired
        @Qualifier(value="oauthAuthorizationCodeGrantTypeTokenRequestValidator")
        private OAuth20TokenRequestValidator validator;

        @Test
        public void verifyPreviousAccessTokensRemoved() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("clientBasicAuth");
            profile.setId("supporting");
            HttpSession session = request.getSession(true);
            Assertions.assertNotNull((Object)session);
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("casuser");
            OAuthRegisteredService registeredService = this.addRegisteredService("https://another.example.com", UUID.randomUUID().toString());
            OAuth20Code code = this.addCode(principal, registeredService);
            OAuth20AccessToken at1 = this.addAccessToken(principal, registeredService, code.getId());
            Assertions.assertNotNull((Object)at1);
            OAuth20AccessToken at2 = this.addAccessToken(principal, registeredService, code.getId());
            Assertions.assertNotNull((Object)at2);
            code.markTicketExpired();
            request.setParameter("code", code.getId());
            profile.setId(registeredService.getClientId());
            request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
            request.setParameter("redirect_uri", registeredService.getServiceId());
            session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
            Assertions.assertNull((Object)this.ticketRegistry.getTicket(at1.getId()));
            Assertions.assertNull((Object)this.ticketRegistry.getTicket(at2.getId()));
        }
    }
}

