/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.validator.token.OAuth20DeviceCodeResponseTypeRequestValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20DeviceCodeResponseTypeRequestValidatorTests
extends AbstractOAuth20Tests {
    @Test
    public void verifySupports() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        OAuth20DeviceCodeResponseTypeRequestValidator validator = new OAuth20DeviceCodeResponseTypeRequestValidator(this.servicesManager, this.serviceFactory, this.oauthRequestParameterResolver);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("response_type", OAuth20ResponseTypes.DEVICE_CODE.getType());
        request.addParameter("client_id", "1");
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertNotNull((Object)validator.getServicesManager());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)validator.getOrder());
        Assertions.assertNotNull((Object)validator.getWebApplicationServiceServiceFactory());
    }

    @Test
    public void verifyValidate() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        OAuth20DeviceCodeResponseTypeRequestValidator validator = new OAuth20DeviceCodeResponseTypeRequestValidator(this.servicesManager, this.serviceFactory, this.oauthRequestParameterResolver);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.setParameter("response_type", "unknown");
        request.addParameter("client_id", "unknown");
        Assertions.assertFalse((boolean)validator.validate((WebContext)context));
        request.setParameter("response_type", OAuth20ResponseTypes.DEVICE_CODE.getType());
        Assertions.assertFalse((boolean)validator.validate((WebContext)context));
        this.addRegisteredService();
        request.setParameter("client_id", "1");
        Assertions.assertTrue((boolean)validator.validate((WebContext)context));
    }
}

