/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.RequestValidatorTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuth")
@TestPropertySource(properties={"cas.authn.oauth.session-replication.replicate-sessions=false"})
public class OAuth20PasswordGrantTypeTokenRequestValidatorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthPasswordGrantTypeTokenRequestValidator")
    private OAuth20TokenRequestValidator validator;
    private OAuthRegisteredService supportingService;
    private OAuthRegisteredService nonSupportingService;
    private OAuthRegisteredService promiscuousService;

    @BeforeEach
    public void before() {
        this.supportingService = RequestValidatorTestUtils.getService("https://google.com", "supporting", "supporting", "secret", CollectionUtils.wrapSet((Object)this.getGrantType()));
        this.nonSupportingService = RequestValidatorTestUtils.getService("https://example.com", "nonsupporting", "nonsupporting", "secret", CollectionUtils.wrapSet((Object)this.getWrongGrantType()));
        this.promiscuousService = RequestValidatorTestUtils.getPromiscuousService("https://another.example.com", "promiscuous", "promiscuous", "secret");
        this.servicesManager.deleteAll();
        this.servicesManager.save(new RegisteredService[]{this.supportingService, this.nonSupportingService, this.promiscuousService});
    }

    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setParameter("grant_type", "unsupported");
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("supporting");
        HttpSession session = request.getSession(true);
        Assertions.assertNotNull((Object)session);
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        request.setParameter("grant_type", this.getGrantType().getType());
        request.setParameter("client_id", this.supportingService.getClientId());
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.setParameter("client_id", this.nonSupportingService.getClientId());
        profile.setId("nonsupporting");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.setParameter("client_id", this.promiscuousService.getClientId());
        profile.setId("promiscuous");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.PASSWORD;
    }

    protected OAuth20GrantTypes getWrongGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }
}

