/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.RequestValidatorTestUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuth")
@TestPropertySource(properties={"cas.authn.oauth.session-replication.replicate-sessions=false"})
public class OAuth20RefreshTokenGrantTypeTokenRequestValidatorTests
extends AbstractOAuth20Tests {
    private static final String SUPPORTING_TICKET = "RT-SUPPORTING";
    private static final String NON_SUPPORTING_TICKET = "RT-NON-SUPPORTING";
    private static final String PROMISCUOUS_TICKET = "RT-PROMISCUOUS";
    @Autowired
    @Qualifier(value="oauthRefreshTokenGrantTypeTokenRequestValidator")
    private OAuth20TokenRequestValidator validator;

    @BeforeEach
    public void before() throws Exception {
        OAuthRegisteredService supportingService = RequestValidatorTestUtils.getService("https://google.com", "supporting", "supporting", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        OAuthRegisteredService nonSupportingService = RequestValidatorTestUtils.getService("https://example.com", "nonsupporting", "nonsupporting", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        OAuthRegisteredService promiscuousService = RequestValidatorTestUtils.getPromiscuousService("https://another.example.com", "promiscuous", "promiscuous", "secret");
        this.servicesManager.deleteAll();
        this.servicesManager.save(new RegisteredService[]{supportingService, nonSupportingService, promiscuousService});
        this.registerTicket(SUPPORTING_TICKET, "supporting");
        this.registerTicket(NON_SUPPORTING_TICKET, "nonsupporting");
        this.registerTicket(PROMISCUOUS_TICKET, "promiscuous");
    }

    @Test
    public void verifyRefreshTokenFromAnotherClientId() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("supporting");
        HttpSession session = request.getSession(true);
        Assertions.assertNotNull((Object)session);
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.getType());
        request.setParameter("client_id", "promiscuous");
        request.setParameter("client_secret", "secret");
        request.setParameter("refresh_token", SUPPORTING_TICKET);
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    @Test
    public void verifyOperationClientSecretPost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("supporting");
        HttpSession session = request.getSession(true);
        Assertions.assertNotNull((Object)session);
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.getType());
        request.setParameter("client_id", "supporting");
        request.setParameter("client_secret", "secret");
        request.setParameter("refresh_token", SUPPORTING_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        profile.setId("nonsupporting");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        request.setParameter("client_id", "nonsupporting");
        request.setParameter("client_secret", "secret");
        request.setParameter("refresh_token", NON_SUPPORTING_TICKET);
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        profile.setId("promiscuous");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        request.setParameter("client_id", "promiscuous");
        request.setParameter("client_secret", "secret");
        request.setParameter("refresh_token", PROMISCUOUS_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    @Test
    public void verifyOperationClientSecretBasic() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("supporting");
        HttpSession session = request.getSession(true);
        Assertions.assertNotNull((Object)session);
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"supporting:secret")));
        request.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.getType());
        request.setParameter("refresh_token", SUPPORTING_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        profile.setId("nonsupporting");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        request.removeHeader("Authorization");
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"nonsupporting:secret")));
        request.setParameter("refresh_token", NON_SUPPORTING_TICKET);
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        profile.setId("promiscuous");
        session.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        request.removeHeader("Authorization");
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"promiscuous:secret")));
        request.setParameter("refresh_token", PROMISCUOUS_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    private void registerTicket(String name, String clientId) throws Exception {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        OAuth20RefreshToken token = (OAuth20RefreshToken)Mockito.mock(OAuth20RefreshToken.class);
        Mockito.when((Object)token.getId()).thenReturn((Object)name);
        Mockito.when((Object)token.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService((String)name));
        Mockito.when((Object)token.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)token.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)token.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)token.getClientId()).thenReturn((Object)clientId);
        this.ticketRegistry.addTicket((Ticket)token);
    }
}

