/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.RequestValidatorTestUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20RevocationRequestValidatorTests
extends AbstractOAuth20Tests {
    private static final String SUPPORTING_SERVICE_TICKET = "RT-SUPPORTING";
    @Autowired
    @Qualifier(value="oauthRevocationRequestValidator")
    private OAuth20TokenRequestValidator validator;

    @BeforeEach
    public void before() throws Exception {
        this.servicesManager.deleteAll();
        OAuthRegisteredService supportingService = RequestValidatorTestUtils.getService("https://google.com", "supporting", "supporting", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        this.servicesManager.save((RegisteredService)supportingService);
        this.registerTicket(SUPPORTING_SERVICE_TICKET);
    }

    @Test
    public void verifyOperationClientSecretPost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setParameter("client_id", "supporting");
        request.setParameter("client_secret", "secret");
        request.setParameter("token", SUPPORTING_SERVICE_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.removeAllParameters();
        request.setParameter("client_id", "supporting");
        request.setParameter("client_secret", "secret");
        Assertions.assertFalse((boolean)this.validator.supports((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.removeAllParameters();
        request.setParameter("client_id", "nonsupporting");
        request.setParameter("client_secret", "secret");
        request.setParameter("token", SUPPORTING_SERVICE_TICKET);
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    @Test
    public void verifyOperationClientSecretBasic() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpUtils.createBasicAuthHeaders((String)"supporting", (String)"secret").forEach((arg_0, arg_1) -> ((MockHttpServletRequest)request).addHeader(arg_0, arg_1));
        request.setParameter("token", SUPPORTING_SERVICE_TICKET);
        Assertions.assertTrue((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.removeHeader("Authorization");
        request.removeAllParameters();
        HttpUtils.createBasicAuthHeaders((String)"supporting", (String)"secret").forEach((arg_0, arg_1) -> ((MockHttpServletRequest)request).addHeader(arg_0, arg_1));
        Assertions.assertFalse((boolean)this.validator.supports((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
        request.removeHeader("Authorization");
        request.removeAllParameters();
        HttpUtils.createBasicAuthHeaders((String)"nonsupporting", (String)"secret").forEach((arg_0, arg_1) -> ((MockHttpServletRequest)request).addHeader(arg_0, arg_1));
        request.setParameter("token", SUPPORTING_SERVICE_TICKET);
        Assertions.assertFalse((boolean)this.validator.validate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response)));
    }

    private void registerTicket(String name) throws Exception {
        OAuth20RefreshToken oauthCode = (OAuth20RefreshToken)Mockito.mock(OAuth20RefreshToken.class);
        Mockito.when((Object)oauthCode.getId()).thenReturn((Object)name);
        Mockito.when((Object)oauthCode.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)oauthCode.getAuthentication()).thenReturn((Object)RegisteredServiceTestUtils.getAuthentication());
        this.ticketRegistry.addTicket((Ticket)oauthCode);
    }
}

