/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;

public final class RequestValidatorTestUtils {
    public static final String SUPPORTING_CLIENT_ID = "supporting";
    public static final String NON_SUPPORTING_CLIENT_ID = "nonsupporting";
    public static final String PROMISCUOUS_CLIENT_ID = "promiscuous";
    public static final String SHARED_SECRET = "secret";

    public static OAuthRegisteredService getService(String serviceId, String name, String clientId, String clientSecret, Set<OAuth20GrantTypes> grantTypes) {
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setName(name);
        registeredService.setClientId(clientId);
        registeredService.setClientSecret(clientSecret);
        registeredService.setServiceId(serviceId);
        registeredService.setSupportedGrantTypes((Set)grantTypes.stream().map(OAuth20GrantTypes::getType).collect(Collectors.toCollection(HashSet::new)));
        return registeredService;
    }

    public static OAuthRegisteredService getPromiscuousService(String serviceId, String name, String clientId, String clientSecret) {
        return RequestValidatorTestUtils.getService(serviceId, name, clientId, clientSecret, new LinkedHashSet<OAuth20GrantTypes>());
    }

    @Generated
    private RequestValidatorTestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

