/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class DefaultOAuth20RequestParameterResolverTests
extends AbstractOAuth20Tests {
    private static MockHttpServletRequest getJwtRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JWTClaimsSet claims = new JWTClaimsSet.Builder().subject("cas").claim("scope", (Object)new String[]{"openid", "profile"}).claim("response", (Object)"code").claim("client_id", List.of("client1", "client2")).build();
        PlainJWT jwt = new PlainJWT(claims);
        String jwtString = jwt.serialize();
        request.removeAllParameters();
        request.addParameter("request", jwtString);
        return request;
    }

    @BeforeEach
    public void onSetUp() {
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyPlainJwtWithoutClientId() {
        MockHttpServletRequest request = DefaultOAuth20RequestParameterResolverTests.getJwtRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Optional scope = this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "scope", List.class);
        Assertions.assertFalse((boolean)scope.isEmpty());
        Assertions.assertTrue((boolean)((List)scope.get()).contains("openid"));
        Assertions.assertTrue((boolean)((List)scope.get()).contains("profile"));
    }

    @Test
    public void verifyPlainJwtWithClientId() {
        MockHttpServletRequest request = DefaultOAuth20RequestParameterResolverTests.getJwtRequest();
        OAuthRegisteredService registeredService = DefaultOAuth20RequestParameterResolverTests.getRegisteredService(UUID.randomUUID().toString(), "secret");
        this.servicesManager.save((RegisteredService)registeredService);
        request.addParameter("client_id", registeredService.getClientId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Optional scope = this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "client_id", List.class);
        Assertions.assertFalse((boolean)scope.isEmpty());
        Assertions.assertTrue((boolean)((List)scope.get()).contains("client1"));
        Assertions.assertTrue((boolean)((List)scope.get()).contains("client2"));
    }
}

