/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuthToken")
public class OAuth20AccessTokenSecurityLogicTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("client_id", "1");
        DefaultSecurityLogic logic = new DefaultSecurityLogic();
        logic.setLoadProfilesFromSession(false);
        DirectClient mockClient = (DirectClient)Mockito.mock(DirectClient.class);
        Mockito.when((Object)mockClient.getName()).thenReturn((Object)"MockIndirectClient");
        Mockito.when((Object)mockClient.isInitialized()).thenReturn((Object)true);
        Mockito.when((Object)mockClient.getCredentials((WebContext)Mockito.any(), (SessionStore)Mockito.any())).thenReturn(Optional.of(new UsernamePasswordCredentials("casuser", "Mellon")));
        CommonProfile profile = new CommonProfile();
        profile.setId(UUID.randomUUID().toString());
        Mockito.when((Object)mockClient.getUserProfile((Credentials)Mockito.any(), (WebContext)Mockito.any(), (SessionStore)Mockito.any())).thenReturn(Optional.of(profile));
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)profile, false);
        UserProfile result = (UserProfile)logic.perform((WebContext)context, (SessionStore)JEESessionStore.INSTANCE, new Config((Client)mockClient), (webContext, sessionStore, collection, objects) -> collection.iterator().next(), (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE, "MockIndirectClient", "isFullyAuthenticated", "securityheaders", new Object[0]);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)1, (int)profileManager.getProfiles().size());
    }
}

