/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.configuration.model.support.oauth.OAuthCsrfCookieProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuthWeb")
@TestPropertySource(properties={"cas.authn.oauth.csrf-cookie.max-age=3600", "cas.authn.oauth.csrf-cookie.path=/cas", "cas.authn.oauth.csrf-cookie.same-site-policy=None", "cas.authn.oauth.csrf-cookie.http-only=true", "cas.authn.oauth.csrf-cookie.secure=true", "cas.authn.oauth.csrf-cookie.domain=mellon.edu"})
public class OAuth20CSRFCookieTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyPropertiesSet() {
        OAuthCsrfCookieProperties csrfCookie = this.casProperties.getAuthn().getOauth().getCsrfCookie();
        Assertions.assertEquals((int)3600, (int)csrfCookie.getMaxAge());
        Assertions.assertEquals((Object)"/cas", (Object)csrfCookie.getPath());
        Assertions.assertEquals((Object)"None", (Object)csrfCookie.getSameSitePolicy());
        Assertions.assertEquals((Object)"mellon.edu", (Object)csrfCookie.getDomain());
        Assertions.assertTrue((boolean)csrfCookie.isHttpOnly());
        Assertions.assertTrue((boolean)csrfCookie.isSecure());
    }
}

