/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuthWeb")
public class OAuth20CasCallbackUrlResolverTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="casCallbackUrlResolver")
    private UrlResolver casCallbackUrlResolver;

    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("client_id", "1");
        request.addParameter("response_mode", OAuth20ResponseModeTypes.FORM_POST.getType());
        request.addParameter("state", UUID.randomUUID().toString());
        request.addParameter("nonce", UUID.randomUUID().toString());
        String output = this.casCallbackUrlResolver.compute(OAuth20Utils.casOAuthCallbackUrl((String)this.casProperties.getServer().getPrefix()), (WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response));
        Assertions.assertNotNull((Object)output);
        URIBuilder uri = new URIBuilder(output);
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("state")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("response_mode")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("client_id")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("nonce")));
    }
}

