/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuthWeb")
public class OAuth20HandlerInterceptorAdapterTests
extends AbstractOAuth20Tests {
    @Override
    @BeforeEach
    public void setup() {
        super.setup();
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyAuthorizationAuth() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.setRequestURI("/authorize");
        request.setParameter("client_id", "1");
        request.setParameter("redirect_uri", "https://oauth.example.org");
        request.setParameter("response_type", OAuth20ResponseTypes.CODE.getType());
        OAuthRegisteredService service = OAuth20HandlerInterceptorAdapterTests.getRegisteredService("https://oauth.example.org", "1", "secret");
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertFalse((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        Assertions.assertFalse((boolean)context.getRequestAttribute("error").isPresent());
        request.removeAllParameters();
        Assertions.assertTrue((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"invalid_request", (Object)context.getRequestAttribute("error").get().toString());
    }

    @Test
    public void verifyRevocationNeedsAuthn() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/revoke");
        Assertions.assertFalse((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        request = new MockHttpServletRequest();
        response = new MockHttpServletResponse();
        request.setRequestURI("/revoke");
        request.setParameter("client_id", "unknown123456");
        Assertions.assertFalse((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyRevocationAuth() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/revoke");
        request.setParameter("client_id", "1");
        OAuthRegisteredService service = OAuth20HandlerInterceptorAdapterTests.getRegisteredService("1", "secret");
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertFalse((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyAccessToken() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/accessToken");
        request.setParameter("access_token", OAuth20HandlerInterceptorAdapterTests.getAccessToken().getId());
        String id = UUID.randomUUID().toString();
        request.setParameter("refresh_token", id);
        request.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.getType());
        Assertions.assertFalse((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyProfile() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/profile");
        request.setParameter("client_id", "1");
        request.setParameter("response_type", OAuth20ResponseTypes.DEVICE_CODE.getType());
        Assertions.assertTrue((boolean)this.oauthHandlerInterceptorAdapter.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }
}

