/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20RefreshTokenTests
extends AbstractOAuth20Tests {
    @BeforeEach
    public void initialize() {
        this.clearAllServices();
        this.ticketRegistry.deleteAll();
    }

    @Test
    public void verifyTicketGrantingRemovalDoesNotRemoveAccessToken() throws Exception {
        OAuthRegisteredService service = this.addRegisteredService();
        service.setGenerateRefreshToken(true);
        service.setRenewRefreshToken(true);
        Pair<String, String> result = this.assertClientOK(service, true);
        OAuth20AccessToken at = (OAuth20AccessToken)this.ticketRegistry.getTicket((String)result.getKey(), OAuth20AccessToken.class);
        Assertions.assertNotNull((Object)at);
        Assertions.assertNotNull((Object)at.getTicketGrantingTicket());
        this.ticketRegistry.deleteTicket(at.getTicketGrantingTicket().getId());
        OAuth20AccessToken at2 = (OAuth20AccessToken)this.ticketRegistry.getTicket(at.getId(), OAuth20AccessToken.class);
        Assertions.assertNotNull((Object)at2);
        OAuth20RefreshToken rt = (OAuth20RefreshToken)this.ticketRegistry.getTicket((String)result.getRight(), OAuth20RefreshToken.class);
        Assertions.assertNotNull((Object)rt);
        Pair<OAuth20AccessToken, OAuth20RefreshToken> result2 = this.assertRefreshTokenOk(service, rt, OAuth20RefreshTokenTests.createPrincipal());
        Assertions.assertNotNull((Object)result2.getKey());
    }

    @Test
    public void verifyRenewingRefreshToken() throws Exception {
        OAuthRegisteredService service = this.addRegisteredService();
        service.setGenerateRefreshToken(true);
        service.setRenewRefreshToken(true);
        Pair<String, String> result = this.assertClientOK(service, true);
        OAuth20AccessToken at = (OAuth20AccessToken)this.ticketRegistry.getTicket((String)result.getLeft(), OAuth20AccessToken.class);
        Assertions.assertNotNull((Object)at);
        Assertions.assertNotNull((Object)at.getTicketGrantingTicket());
        OAuth20RefreshToken rt = (OAuth20RefreshToken)this.ticketRegistry.getTicket((String)result.getRight(), OAuth20RefreshToken.class);
        Assertions.assertNotNull((Object)rt);
        Pair<OAuth20AccessToken, OAuth20RefreshToken> result2 = this.assertRefreshTokenOk(service, rt, OAuth20RefreshTokenTests.createPrincipal());
        Assertions.assertNotNull((Object)result2.getLeft());
        Assertions.assertNotNull((Object)result2.getRight());
        OAuth20RefreshToken rt2 = (OAuth20RefreshToken)result2.getRight();
        Assertions.assertNotEquals((Object)rt.getId(), (Object)rt2.getId());
        Ticket oldRt = this.ticketRegistry.getTicket((String)result.getRight(), ticket -> true);
        Assertions.assertNull((Object)oldRt);
    }
}

