/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.support.oauth.web.OAuth20TicketGrantingTicketAwareSecurityLogic;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuthToken")
public class OAuth20TicketGrantingTicketAwareSecurityLogicTests
extends AbstractOAuth20Tests {
    @Mock
    private CasCookieBuilder ticketGrantingTicketCookieGenerator;

    @BeforeEach
    public void initialize() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void verifyLoadWithBadTicketInSession() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)new BasicUserProfile(), false);
        JEESessionStore.INSTANCE.set((WebContext)context, "ticketGrantingTicketId", (Object)UUID.randomUUID().toString());
        OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry);
        Assertions.assertTrue((boolean)logic.loadProfiles(profileManager, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE, List.of()).isEmpty());
    }

    @Test
    public void verifyLoadWithValidTicket() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)new BasicUserProfile(), false);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(UUID.randomUUID().toString());
        JEESessionStore.INSTANCE.set((WebContext)context, "ticketGrantingTicketId", (Object)tgt.getId());
        this.ticketRegistry.addTicket((Ticket)tgt);
        OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry);
        Assertions.assertFalse((boolean)logic.loadProfiles(profileManager, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE, List.of()).isEmpty());
    }

    @Test
    public void verifyLoadNoProfileWhenNoTgtAvailable() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)new BasicUserProfile(), false);
        OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry);
        Assertions.assertTrue((boolean)logic.loadProfiles(profileManager, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE, List.of()).isEmpty());
    }
}

