/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.audit;

import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.audit.OAuth20AccessTokenGrantRequestAuditResourceResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OAuth")
public class OAuth20AccessTokenGrantRequestAuditResourceResolverTests {
    @Test
    public void verifyAction() {
        OAuth20AccessTokenGrantRequestAuditResourceResolver r = new OAuth20AccessTokenGrantRequestAuditResourceResolver();
        OAuth20Token token = (OAuth20Token)Mockito.mock(OAuth20Token.class);
        Mockito.when((Object)token.getId()).thenReturn((Object)"CODE");
        AbstractWebApplicationService tokenService = RegisteredServiceTestUtils.getService();
        Mockito.when((Object)token.getService()).thenReturn((Object)tokenService);
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication();
        Mockito.when((Object)token.getAuthentication()).thenReturn((Object)authentication);
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setClientId("CLIENTID");
        service.setName("OAUTH");
        service.setId(123L);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().scopes(CollectionUtils.wrapSet((Object)"email")).service((Service)tokenService).authentication(authentication).registeredService(service).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).token(token).redirectUri("https://oauth.example.org").build();
        AuditableExecutionResult result = AuditableExecutionResult.builder().executionResult((Object)holder).build();
        Assertions.assertTrue((r.resolveFrom((JoinPoint)Mockito.mock(JoinPoint.class), (Object)result).length > 0 ? 1 : 0) != 0);
    }
}

