/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.audit;

import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.audit.OAuth20UserProfileDataAuditResourceResolver;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OAuth")
public class OAuth20UserProfileDataAuditResourceResolverTests {
    @Test
    public void verifyAction() {
        OAuth20UserProfileDataAuditResourceResolver r = new OAuth20UserProfileDataAuditResourceResolver();
        OAuth20AccessToken token = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)token.getId()).thenReturn((Object)"CODE");
        Mockito.when((Object)token.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService());
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setClientId("CLIENTID");
        service.setName("OAUTH");
        service.setId(123L);
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{token});
        String[] result = r.resolveFrom(jp, (Object)CollectionUtils.wrap((String)"id", (Object)"id", (String)"client_id", (Object)"clientid", (String)"service", (Object)"service", (String)"scopes", (Object)CollectionUtils.wrapSet((Object)"email"), (String)"attributes", (Object)CollectionUtils.wrap((String)"attributeName", (Object)"attributeValue")));
        Assertions.assertTrue((result.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyActionFromToken() {
        OAuth20UserProfileDataAuditResourceResolver r = new OAuth20UserProfileDataAuditResourceResolver();
        OAuth20AccessToken token = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)token.getId()).thenReturn((Object)"CODE");
        Mockito.when((Object)token.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService());
        Mockito.when((Object)token.getClientId()).thenReturn((Object)"CLIENTID");
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{token});
        String[] result = r.resolveFrom(jp, (Object)CollectionUtils.wrap((String)"id", (Object)"id", (String)"scopes", (Object)CollectionUtils.wrapSet((Object)"email"), (String)"attributes", (Object)CollectionUtils.wrap((String)"attributeName", (Object)"attributeValue")));
        Assertions.assertTrue((result.length > 0 ? 1 : 0) != 0);
    }
}

