/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuthWeb")
public class OAuth20AccessTokenEndpointControllerTests
extends AbstractOAuth20Tests {
    public static Stream<OAuthRegisteredService> getParameters() {
        return Stream.of(OAuth20AccessTokenEndpointControllerTests.getRegisteredService("http://someurl", "secret", CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE)), OAuth20AccessTokenEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>()));
    }

    @BeforeEach
    public void initialize() {
        this.clearAllServices();
        this.ticketRegistry.deleteAll();
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientNoClientId(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20Code code = this.addCode(principal, registeredService);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientNoRedirectUri() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientNoAuthorizationCode() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientBadGrantType() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", "badValue");
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientDisallowedGrantType() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.CLIENT_CREDENTIALS.getType());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientNoClientSecret() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientNoCode() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        this.addCode(principal, service);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientNoCasService(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuth20Code code = this.addCode(principal, registeredService);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientRedirectUriDoesNotStartWithServiceId(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someotherurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20Code code = this.addCode(principal, registeredService);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientWrongSecret(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "wrongSecret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20Code code = this.addCode(principal, registeredService);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyClientEmptySecret() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE), "");
        OAuth20Code code = this.addCode(principal, service);
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
    }

    @Test
    public void verifyPKCECodeVerifier() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("code_verifier", "myclientcode");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE), "secret");
        OAuth20Code code = this.addCodeWithChallenge(principal, service, "myclientcode", "plain");
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyPKCEInvalidCodeVerifier(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("code_verifier", "invalidcode");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20Code code = this.addCodeWithChallenge(principal, registeredService, "myclientcode", "plain");
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyPKCEEmptySecret() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "");
        mockRequest.setParameter("code_verifier", "myclientcode");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE), "");
        OAuth20Code code = this.addCodeWithChallenge(principal, service, "myclientcode", "plain");
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyPKCEWrongSecret(OAuthRegisteredService registeredService) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "wrongSecret");
        mockRequest.setParameter("code_verifier", "myclientcode");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20Code code = this.addCodeWithChallenge(principal, registeredService, "myclientcode", "plain");
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientExpiredCode(OAuthRegisteredService registeredService) throws Exception {
        this.servicesManager.save((RegisteredService)registeredService);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("attributeName", List.of("attributeValue"));
        List<String> list = List.of("attributeValue", "attributeValue");
        map.put("attributeName2", list);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", map);
        Authentication authentication = OAuth20AccessTokenEndpointControllerTests.getAuthentication(principal);
        OAuth20DefaultOAuthCodeFactory expiringOAuthCodeFactory = new OAuth20DefaultOAuthCodeFactory((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), OAuth20AccessTokenEndpointControllerTests.alwaysExpiresExpirationPolicyBuilder(), this.servicesManager, CipherExecutor.noOpOfStringToString());
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20Code code = expiringOAuthCodeFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), null, null, "1", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("code", code.getId());
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientAuthByParameter(OAuthRegisteredService registeredService) {
        this.servicesManager.save((RegisteredService)registeredService);
        this.assertClientOK(registeredService, false);
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientAuthWithJwtAccessToken(OAuthRegisteredService registeredService) {
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        this.assertClientOK(registeredService, false);
    }

    @Test
    public void verifyDeviceFlowGeneratesCode() throws Exception {
        this.addRegisteredService();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.DEVICE_CODE.getType());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Map model = mv.getModel();
        Assertions.assertTrue((boolean)model.containsKey("device_code"));
        Assertions.assertTrue((boolean)model.containsKey("verification_uri"));
        Assertions.assertTrue((boolean)model.containsKey("user_code"));
        Assertions.assertTrue((boolean)model.containsKey("interval"));
        Assertions.assertTrue((boolean)model.containsKey("expires_in"));
        String devCode = model.get("device_code").toString();
        String userCode = model.get("user_code").toString();
        MockHttpServletRequest devReq = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/device");
        devReq.setParameter("usercode", userCode);
        MockHttpServletResponse devResp = new MockHttpServletResponse();
        ModelAndView mvDev = this.deviceController.handlePostRequest((HttpServletRequest)devReq, (HttpServletResponse)devResp);
        Assertions.assertNotNull((Object)mvDev);
        HttpStatus status = mvDev.getStatus();
        Assertions.assertNotNull((Object)status);
        Assertions.assertTrue((boolean)status.is2xxSuccessful());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.DEVICE_CODE.getType());
        mockRequest.setParameter("device_code", devCode);
        MockHttpServletResponse approveResp = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)approveResp, null);
        ModelAndView mvApproved = this.accessTokenController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)approveResp);
        Assertions.assertTrue((boolean)mvApproved.getModel().containsKey("access_token"));
        Assertions.assertEquals((Object)this.getDefaultAccessTokenExpiration(), mvApproved.getModel().get("expires_in"));
        Assertions.assertTrue((boolean)mvApproved.getModel().containsKey("token_type"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void verifyClientAuthByHeader(OAuthRegisteredService registeredService) {
        this.servicesManager.save((RegisteredService)registeredService);
        this.assertClientOK(registeredService, false);
    }

    @Test
    public void verifyClientAuthByParameterWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        service.setGenerateRefreshToken(true);
        this.assertClientOK(service, true);
    }

    @Test
    public void verifyClientAuthByHeaderWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        service.setGenerateRefreshToken(true);
        this.assertClientOK(service, true);
    }

    @Test
    public void verifyClientAuthJsonByParameterWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        service.setGenerateRefreshToken(true);
        this.assertClientOK(service, true);
    }

    @Test
    public void verifyClientAuthJsonByHeaderWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        service.setGenerateRefreshToken(true);
        this.assertClientOK(service, true);
    }

    @Test
    public void ensureOnlyRefreshTokenIsAcceptedForRefreshGrant() throws Exception {
        this.addRegisteredService(true, CollectionUtils.wrapSet((Object[])new OAuth20GrantTypes[]{OAuth20GrantTypes.PASSWORD, OAuth20GrantTypes.REFRESH_TOKEN}));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        MockHttpSession mockSession = new MockHttpSession();
        mockRequest.setSession((HttpSession)mockSession);
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "test");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("refresh_token"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String refreshToken = mv.getModel().get("refresh_token").toString();
        String accessToken = mv.getModel().get("access_token").toString();
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("refresh_token", accessToken);
        mockResponse = new MockHttpServletResponse();
        this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        mockRequest.setParameter("refresh_token", refreshToken);
        mockResponse = new MockHttpServletResponse();
        mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
    }

    @Test
    public void verifyUserNoClientId() throws Exception {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "test");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyUserNoCasService() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "test");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyUserBadAuthorizationCode() throws Exception {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.AUTHORIZATION_CODE));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "test");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyUserBadCredentials() throws Exception {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "badPassword");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyUserAuth() {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        this.assertUserAuth(false, true);
    }

    @Test
    public void verifyUserAuthForServiceWithoutSecret() {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD), "");
        this.assertUserAuth(false, false);
    }

    @Test
    public void verifyUserAuthWithRefreshToken() {
        OAuthRegisteredService registeredService = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        registeredService.setGenerateRefreshToken(true);
        this.assertUserAuth(true, true);
    }

    @Test
    public void verifyJsonUserAuth() {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        this.assertUserAuth(false, true);
    }

    @Test
    public void verifyJsonUserAuthWithRefreshToken() {
        OAuthRegisteredService registeredService = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.PASSWORD));
        registeredService.setGenerateRefreshToken(true);
        this.assertUserAuth(true, true);
    }

    @Test
    public void verifyRefreshTokenExpiredToken() throws Exception {
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService registeredService = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        Authentication authentication = OAuth20AccessTokenEndpointControllerTests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20DefaultRefreshTokenFactory expiringRefreshTokenFactory = new OAuth20DefaultRefreshTokenFactory(OAuth20AccessTokenEndpointControllerTests.alwaysExpiresExpirationPolicyBuilder(), this.servicesManager);
        OAuth20RefreshToken refreshToken = expiringRefreshTokenFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "1", "", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)refreshToken);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyRefreshTokenBadCredentials() throws Exception {
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        OAuth20RefreshToken refreshToken = this.addRefreshToken(principal, service);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "wrongSecret");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)401, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyRefreshTokenEmptySecret() throws Exception {
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN), "");
        OAuth20RefreshToken refreshToken = this.addRefreshToken(principal, service);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
    }

    @Test
    public void verifyRefreshTokenMissingToken() throws Exception {
        this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_grant", mv.getModel().get("error"));
    }

    @Test
    public void verifyRefreshTokenOKWithExpiredTicketGrantingTicket() throws Exception {
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        OAuth20RefreshToken refreshToken = this.addRefreshToken(principal, service);
        refreshToken.getTicketGrantingTicket().markTicketExpired();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        String accessTokenId = mv.getModel().get("access_token").toString();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(accessTokenId, OAuth20AccessToken.class);
        Assertions.assertEquals((Object)principal, (Object)accessToken.getAuthentication().getPrincipal());
        int timeLeft = Integer.parseInt(mv.getModel().get("expires_in").toString());
        Assertions.assertTrue((timeLeft >= 7188 ? 1 : 0) != 0);
    }

    @Test
    public void verifyRefreshTokenOK() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        this.assertRefreshTokenOk(service);
    }

    @Test
    public void verifyRefreshTokenOKWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        service.setGenerateRefreshToken(true);
        service.setRenewRefreshToken(true);
        this.assertRefreshTokenOk(service);
    }

    @Test
    public void verifyJsonRefreshTokenOK() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        this.assertRefreshTokenOk(service);
    }

    @Test
    public void verifyJsonRefreshTokenOKWithRefreshToken() {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        service.setGenerateRefreshToken(true);
        service.setRenewRefreshToken(true);
        this.assertRefreshTokenOk(service);
    }

    @Test
    public void verifyAccessTokenRequestWithRefreshTokenCannotExceedScopes() throws Exception {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuth20RefreshToken refreshToken = this.addRefreshTokenWithScope(principal, List.of("profile"), service);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        mockRequest.setParameter("scope", "email");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)400, (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_scope", (Object)mv.getModel().get("error").toString());
    }

    @Test
    public void verifyAccessTokenRequestWithRefreshTokenWithoutRequestingScopes() throws Exception {
        OAuthRegisteredService service = this.addRegisteredService(CollectionUtils.wrapSet((Object)OAuth20GrantTypes.REFRESH_TOKEN));
        Principal principal = OAuth20AccessTokenEndpointControllerTests.createPrincipal();
        OAuth20RefreshToken refreshToken = this.addRefreshTokenWithScope(principal, List.of("profile"), service);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        if (!service.isRenewRefreshToken()) {
            Assertions.assertFalse((boolean)mv.getModel().containsKey("refresh_token"));
        } else {
            Assertions.assertTrue((boolean)mv.getModel().containsKey("refresh_token"));
        }
        OAuth20RefreshToken newRefreshToken = service.isRenewRefreshToken() ? (OAuth20RefreshToken)this.ticketRegistry.getTicket(mv.getModel().get("refresh_token").toString(), OAuth20RefreshToken.class) : refreshToken;
        Assertions.assertNotNull((Object)newRefreshToken);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("expires_in"));
        String accessTokenId = mv.getModel().get("access_token").toString();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(accessTokenId, OAuth20AccessToken.class);
        Assertions.assertEquals((Object)principal, (Object)accessToken.getAuthentication().getPrincipal());
        int timeLeft = Integer.parseInt(mv.getModel().get("expires_in").toString());
        Assertions.assertTrue((timeLeft >= 7188 ? 1 : 0) != 0);
    }

    private void assertUserAuth(boolean refreshToken, boolean withClientSecret) {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("client_id", "1");
        if (withClientSecret) {
            mockRequest.setParameter("client_secret", "secret");
        }
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.PASSWORD.name().toLowerCase());
        mockRequest.setParameter("username", "test");
        mockRequest.setParameter("password", "test");
        mockRequest.addHeader("service", (Object)"http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        if (refreshToken) {
            Assertions.assertTrue((boolean)mv.getModel().containsKey("refresh_token"));
        }
        Assertions.assertTrue((boolean)mv.getModel().containsKey("expires_in"));
        String accessTokenId = mv.getModel().get("access_token").toString();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(accessTokenId, OAuth20AccessToken.class);
        Assertions.assertEquals((Object)"test", (Object)accessToken.getAuthentication().getPrincipal().getId());
        int timeLeft = Integer.parseInt(mv.getModel().get("expires_in").toString());
        Assertions.assertTrue((timeLeft >= 7188 ? 1 : 0) != 0);
    }

    private OAuth20RefreshToken addRefreshTokenWithScope(Principal principal, List<String> scopes, OAuthRegisteredService registeredService) throws Exception {
        Authentication authentication = OAuth20AccessTokenEndpointControllerTests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20RefreshToken refreshToken = this.oAuthRefreshTokenFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), scopes, "1", "", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)refreshToken);
        return refreshToken;
    }
}

