/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketSessionTrackingPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuthWeb")
public class OAuth20AuthorizeEndpointControllerTests
extends AbstractOAuth20Tests {
    private static final String AUTHORIZE_URL = "https://casserver/oauth2.0/authorize";
    private static final String SERVICE_NAME = "serviceName";
    private static final String STATE = "state";
    @Autowired
    @Qualifier(value="authorizeController")
    private OAuth20AuthorizeEndpointController oAuth20AuthorizeEndpointController;

    @Test
    public void verifyNoClientId() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequestPost((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyNoRedirectUri() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyNoResponseType() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyBadResponseType() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", "badvalue");
        mockRequest.setAttribute("error", (Object)"invalid_request");
        mockRequest.setAttribute("error_with_callback", (Object)true);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertTrue((boolean)(modelAndView.getView() instanceof RedirectView));
        RedirectView modelView = (RedirectView)modelAndView.getView();
        Assertions.assertEquals((Object)"http://someurl", (Object)modelView.getUrl());
        Assertions.assertTrue((boolean)modelAndView.getModel().containsKey("error"));
        Assertions.assertEquals((Object)"invalid_request", (Object)modelAndView.getModel().get("error").toString());
    }

    @Test
    public void verifyNoCasService() {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyCasClientCanValidate() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        Optional redirect = this.oauthCasClient.getRedirectionAction((WebContext)new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse), this.oauthDistributedSessionStore);
        Assertions.assertTrue((boolean)redirect.isPresent());
        String callbackUrl = ((WithLocationAction)redirect.get()).getLocation();
        CasRegisteredService callback = RegisteredServiceTestUtils.getRegisteredService((String)callbackUrl);
        this.servicesManager.save((RegisteredService)callback);
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        this.servicesManager.save((RegisteredService)service);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(UUID.randomUUID().toString());
        this.ticketRegistry.addTicket((Ticket)tgt);
        ServiceTicketSessionTrackingPolicy trackingPolicy = (ServiceTicketSessionTrackingPolicy)Mockito.mock(ServiceTicketSessionTrackingPolicy.class);
        AbstractWebApplicationService ticketService = RegisteredServiceTestUtils.getService((String)"http://someurl");
        ticketService.getAttributes().put("client_id", List.of(service.getClientId()));
        ServiceTicket st1 = tgt.grantServiceTicket((Service)ticketService, trackingPolicy);
        this.ticketRegistry.addTicket((Ticket)st1);
        this.ticketRegistry.updateTicket((Ticket)tgt);
        mockRequest.addParameter("client_id", service.getClientId());
        mockRequest.addParameter("ticket", st1.getId());
        mockRequest.addParameter("service", callbackUrl);
        Optional result = this.oauthCasClient.getCredentials((WebContext)new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse), this.oauthDistributedSessionStore);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertNotNull((Object)((Credentials)result.get()).getUserProfile());
    }

    @Test
    public void verifyRedirectUriDoesNotStartWithServiceId() {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.servicesManager.save((RegisteredService)OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someotherurl", "1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequestPost((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyCodeNoProfile() {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oAuth20AuthorizeEndpointController.handleRequestPost((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse));
    }

    @Test
    public void verifyMissingTicketGrantingTicket() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getServicesManager().save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)"error/casServiceErrorView", (Object)modelAndView.getViewName());
    }

    @Test
    public void verifyServiceAccessDenied() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        service.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(Map.of("required", Set.of("value1"))));
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getServicesManager().save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)"error/casServiceErrorView", (Object)modelAndView.getViewName());
    }

    @Test
    public void verifyCodeRedirectToClient() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        CasConfigurationProperties properties = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getCasProperties();
        properties.getAuthn().getOauth().getSessionReplication().getCookie().setAutoConfigureCookiePath(true);
        properties.getAuthn().getOauth().getSessionReplication().setReplicateSessions(true);
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getOauthDistributedSessionCookieGenerator().setCookiePath("");
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getServicesManager().save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertEquals((Object)"http://someurl", (Object)redirectUrl);
        Assertions.assertEquals((Object)"/", (Object)this.oAuth20AuthorizeEndpointController.getConfigurationContext().getOauthDistributedSessionCookieGenerator().getCookiePath());
        Object code = modelAndView.getModelMap().get((Object)"code");
        OAuth20Code oAuthCode = (OAuth20Code)this.ticketRegistry.getTicket(String.valueOf(code));
        Assertions.assertNotNull((Object)oAuthCode);
        Principal principal = oAuthCode.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    @Test
    public void verifyTokenRedirectToClient() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuth20ConfigurationContext oauthContext = this.oAuth20AuthorizeEndpointController.getConfigurationContext();
        oauthContext.getCasProperties().getAuthn().getOauth().getSessionReplication().getCookie().setAutoConfigureCookiePath(false);
        oauthContext.getOauthDistributedSessionCookieGenerator().setCookiePath("");
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertTrue((boolean)redirectUrl.startsWith("http://someurl#access_token="));
        Assertions.assertEquals((Object)"/", (Object)this.oAuth20AuthorizeEndpointController.getConfigurationContext().getOauthDistributedSessionCookieGenerator().getCookiePath());
        String code = StringUtils.substringBetween((String)redirectUrl, (String)"#access_token=", (String)"&token_type=Bearer");
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(code, OAuth20AccessToken.class);
        Assertions.assertNotNull((Object)accessToken);
        Principal principal = accessToken.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
        String expiresIn = StringUtils.substringAfter((String)redirectUrl, (String)"&expires_in=");
        Assertions.assertEquals((long)this.getDefaultAccessTokenExpiration(), (long)Long.parseLong(expiresIn));
    }

    @Test
    public void verifyPerServiceExpiration() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy expirationPolicy = new DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy();
        expirationPolicy.setMaxTimeToLive("5005");
        expirationPolicy.setTimeToKill("1001");
        service.setAccessTokenExpirationPolicy((RegisteredServiceOAuthAccessTokenExpirationPolicy)expirationPolicy);
        service.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertTrue((boolean)redirectUrl.startsWith("http://someurl#access_token="));
        String at = StringUtils.substringBetween((String)redirectUrl, (String)"#access_token=", (String)"&token_type=Bearer");
        String decoded = this.oauthAccessTokenJwtCipherExecutor.decode((Object)at).toString();
        Assertions.assertNotNull((Object)decoded);
        JwtClaims jwt = JwtClaims.parse((String)decoded);
        Assertions.assertNotNull((Object)jwt);
        Assertions.assertNotNull((Object)jwt.getExpirationTime());
        Assertions.assertNotNull((Object)jwt.getIssuedAt());
        OAuth20AuthorizeEndpointControllerTests.assertEqualsWithDelta(Long.parseLong(expirationPolicy.getMaxTimeToLive()), jwt.getExpirationTime().getValue() - jwt.getIssuedAt().getValue(), 2L);
        String expiresIn = StringUtils.substringAfter((String)redirectUrl, (String)"&expires_in=");
        Assertions.assertEquals((Object)expirationPolicy.getMaxTimeToLive(), (Object)expiresIn);
    }

    @Test
    public void verifyCodeRedirectToClientWithState() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setParameter(STATE, STATE);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertEquals((Object)"http://someurl", (Object)redirectUrl);
        Object code = modelAndView.getModelMap().getAttribute("code");
        OAuth20Code oAuthCode = (OAuth20Code)this.ticketRegistry.getTicket(String.valueOf(code));
        Assertions.assertNotNull((Object)oAuthCode);
        Principal principal = oAuthCode.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    @Test
    public void verifyTokenRedirectToClientWithState() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        mockRequest.setParameter(STATE, STATE);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        Object redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        redirectUrl = (String)redirectUrl + "&";
        Assertions.assertTrue((boolean)((String)redirectUrl).startsWith("http://someurl#access_token="));
        String code = StringUtils.substringBetween((String)redirectUrl, (String)"#access_token=", (String)"&");
        String state = StringUtils.substringBetween((String)redirectUrl, (String)"state=", (String)"&");
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(code);
        Assertions.assertNotNull((Object)accessToken);
        Assertions.assertEquals((Object)STATE, (Object)state);
        Principal principal = accessToken.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    @Test
    public void verifyCodeRedirectToClientApproved() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(false);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        sessionStore.set((WebContext)context, "bypass_approval_prompt", (Object)"true");
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertEquals((Object)"http://someurl", (Object)redirectUrl);
        Object code = modelAndView.getModelMap().get((Object)"code");
        OAuth20Code oAuthCode = (OAuth20Code)this.ticketRegistry.getTicket(String.valueOf(code));
        Assertions.assertNotNull((Object)oAuthCode);
        Principal principal = oAuthCode.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    @Test
    public void verifyTokenRedirectToClientApproved() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(false);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        sessionStore.set((WebContext)context, "bypass_approval_prompt", (Object)"true");
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertTrue((boolean)redirectUrl.startsWith("http://someurl#access_token="));
        String code = StringUtils.substringBetween((String)redirectUrl, (String)"#access_token=", (String)"&token_type=Bearer");
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(code);
        Assertions.assertNotNull((Object)accessToken);
        Principal principal = accessToken.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    @Test
    public void verifyRedirectToApproval() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.CODE.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(false);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)"oauthConfirmView", (Object)modelAndView.getViewName());
        Map model = modelAndView.getModel();
        Assertions.assertEquals((Object)"https://casserver/oauth2.0/authorize?bypass_approval_prompt=true", model.get("callbackUrl"));
        Assertions.assertEquals((Object)SERVICE_NAME, model.get(SERVICE_NAME));
    }

    @Test
    public void verifyTokenRedirectToClientApprovedWithJwtToken() throws Exception {
        this.clearAllServices();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/authorize");
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("redirect_uri", "http://someurl");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setServerName("casserver");
        mockRequest.setServerPort(443);
        mockRequest.setScheme("https");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OAuthRegisteredService service = OAuth20AuthorizeEndpointControllerTests.getRegisteredService("http://someurl", SERVICE_NAME);
        service.setBypassApprovalPrompt(true);
        service.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "jerome");
        attributes.put("lastName", "LELEU");
        profile.addAttributes(attributes);
        MockHttpSession session = new MockHttpSession();
        mockRequest.setSession((HttpSession)session);
        SessionStore sessionStore = this.oAuth20AuthorizeEndpointController.getConfigurationContext().getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        this.oAuth20AuthorizeEndpointController.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        sessionStore.set((WebContext)context, "bypass_approval_prompt", (Object)"true");
        ModelAndView modelAndView = this.oAuth20AuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        RedirectView redirectView = (RedirectView)view;
        String redirectUrl = redirectView.getUrl();
        Assertions.assertNotNull((Object)redirectUrl);
        Assertions.assertTrue((boolean)redirectUrl.startsWith("http://someurl#access_token="));
        String at = StringUtils.substringBetween((String)redirectUrl, (String)"#access_token=", (String)"&token_type=Bearer");
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(at));
        String decoded = this.oauthAccessTokenJwtCipherExecutor.decode((Object)at).toString();
        Assertions.assertNotNull((Object)decoded);
        JwtClaims jwt = JwtClaims.parse((String)decoded);
        Assertions.assertNotNull((Object)jwt);
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(jwt.getJwtId(), OAuth20AccessToken.class);
        Assertions.assertNotNull((Object)accessToken);
        Principal principal = accessToken.getAuthentication().getPrincipal();
        Assertions.assertEquals((Object)"casuser", (Object)principal.getId());
        Map principalAttributes = principal.getAttributes();
        Assertions.assertEquals((int)attributes.size(), (int)principalAttributes.size());
        Assertions.assertEquals((Object)"jerome", ((List)principalAttributes.get("firstName")).get(0));
    }

    protected static OAuthRegisteredService getRegisteredService(String serviceId, String name) {
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setName(name);
        service.setServiceId(serviceId);
        service.setClientId("1");
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(List.of("firstName")));
        return service;
    }

    @Override
    protected void clearAllServices() {
        Collection col = this.servicesManager.getAllServices();
        col.forEach(r -> this.servicesManager.delete(r.getId()));
    }

    private static void assertEqualsWithDelta(long expected, long actual, long delta) {
        Assertions.assertTrue((Math.abs(expected - actual) <= delta ? 1 : 0) != 0);
    }
}

