/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20CallbackAuthorizeEndpointController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuthWeb")
public class OAuth20CallbackAuthorizeEndpointControllerTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="callbackAuthorizeController")
    private OAuth20CallbackAuthorizeEndpointController callbackAuthorizeController;

    @BeforeEach
    public void initialize() {
        this.clearAllServices();
        this.addRegisteredService();
    }

    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        request.addParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView view = this.callbackAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"http://someurl", (Object)((RedirectView)view.getView()).getUrl());
    }

    @Test
    public void verifyOperationWithoutRedirectUri() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView view = this.callbackAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"/", (Object)((RedirectView)view.getView()).getUrl());
    }

    @Test
    public void verifyOperationWithoutClientId() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView view = this.callbackAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"/", (Object)((RedirectView)view.getView()).getUrl());
    }

    @Test
    public void verifyOperationBadClientId() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "badClientId");
        request.addParameter("redirect_uri", "http://someurl");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView view = this.callbackAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"/", (Object)((RedirectView)view.getView()).getUrl());
    }

    @Test
    public void verifyOperationBadRedirectUri() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        request.addParameter("redirect_uri", "http://badredirecturi");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView view = this.callbackAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"/", (Object)((RedirectView)view.getView()).getUrl());
    }
}

