/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20DeviceUserCodeApprovalEndpointController;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuthWeb")
public class OAuth20DeviceUserCodeApprovalEndpointControllerTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="deviceUserCodeApprovalEndpointController")
    private OAuth20DeviceUserCodeApprovalEndpointController callbackAuthorizeController;

    @BeforeEach
    public void initialize() {
        this.clearAllServices();
    }

    @Test
    public void verifyGet() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.callbackAuthorizeController.handleGetRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("prefix"));
        Assertions.assertFalse((boolean)mv.getModel().containsKey("error"));
        Assertions.assertEquals((Object)"oauthDeviceCodeApprovalView", (Object)mv.getViewName());
    }

    @Test
    public void verifyPostNoCode() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.callbackAuthorizeController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error"));
        String id = UUID.randomUUID().toString();
        request.setParameter("usercode", id);
        mv = this.callbackAuthorizeController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error"));
    }

    @Test
    public void verifyApproval() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        OAuth20DeviceToken devCode = this.defaultDeviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService());
        OAuth20DeviceUserCode uc = this.defaultDeviceUserCodeFactory.createDeviceUserCode(devCode);
        this.ticketRegistry.addTicket((Ticket)uc);
        request.setParameter("usercode", uc.getId());
        ModelAndView mv = this.callbackAuthorizeController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)mv.getModel().containsKey("error"));
        Assertions.assertTrue((boolean)uc.isUserCodeApproved());
        Assertions.assertEquals((Object)"oauthDeviceCodeApprovedView", (Object)mv.getViewName());
        mv = this.callbackAuthorizeController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("prefix"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error"));
    }
}

