/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20IntrospectionEndpointController;
import org.apereo.cas.support.oauth.web.response.introspection.BaseOAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenFailureResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenSuccessResponse;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuthWeb")
public class OAuth20IntrospectionEndpointControllerTests
extends AbstractOAuth20Tests {
    private static final String CLIENT_ID2 = "2";
    @Autowired
    @Qualifier(value="introspectionEndpointController")
    private OAuth20IntrospectionEndpointController<OAuth20ConfigurationContext> introspectionEndpoint;

    @BeforeEach
    public void initialize() {
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyBadCredentialsOperation() {
        OAuth20IntrospectionAccessTokenFailureResponse body = (OAuth20IntrospectionAccessTokenFailureResponse)this.internalVerifyOperation("---");
        Assertions.assertNotNull((Object)body.getError());
    }

    @Test
    public void verifyOperation() {
        String auth = "1:secret";
        this.addRegisteredService();
        OAuth20IntrospectionAccessTokenSuccessResponse body = (OAuth20IntrospectionAccessTokenSuccessResponse)this.internalVerifyOperation("1:secret");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)"1", (Object)body.getClientId());
        Assertions.assertEquals((Object)"http://serviceurl", (Object)body.getAud());
    }

    @Test
    public void verifyBadSecret() {
        String auth = "1:secret";
        this.addRegisteredService("http://serviceurl", UUID.randomUUID().toString());
        OAuth20IntrospectionAccessTokenFailureResponse body = (OAuth20IntrospectionAccessTokenFailureResponse)this.internalVerifyOperation("1:secret");
        Assertions.assertNotNull((Object)body.getError());
    }

    @Test
    public void verifyOperationFromOtherClient() {
        OAuthRegisteredService registeredService2 = OAuth20IntrospectionEndpointControllerTests.getRegisteredService("http://someurl", CLIENT_ID2, "secret");
        this.servicesManager.save((RegisteredService)registeredService2);
        String auth2 = "2:secret";
        OAuth20IntrospectionAccessTokenSuccessResponse body = (OAuth20IntrospectionAccessTokenSuccessResponse)this.internalVerifyOperation("2:secret");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)"1", (Object)body.getClientId());
        Assertions.assertEquals((Object)"http://serviceurl", (Object)body.getAud());
    }

    @Test
    public void verifyNoService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        String id = UUID.randomUUID().toString();
        String auth = id + ":secret";
        String value = EncodingUtils.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuthRegisteredService registeredService = OAuth20IntrospectionEndpointControllerTests.getRegisteredService(id, id);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        String at = mv.getModel().get("access_token").toString();
        request.addParameter("access_token", at);
        ResponseEntity result = this.introspectionEndpoint.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)result.getStatusCode());
    }

    @Test
    public void verifyUnauthzOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.introspectionEndpoint.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)result.getStatusCode());
    }

    @Test
    public void verifyBadOperation() {
        this.addRegisteredService();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        String auth = "1:secret";
        String value = EncodingUtils.encodeBase64((byte[])"1:secret".getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        ResponseEntity result = this.introspectionEndpoint.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)result.getStatusCode());
    }

    protected BaseOAuth20IntrospectionAccessTokenResponse internalVerifyOperation(String auth) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        String value = EncodingUtils.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuthRegisteredService registeredService = this.addRegisteredService();
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        String at = mv.getModel().get("access_token").toString();
        request.addParameter("token", at);
        ResponseEntity entity = this.introspectionEndpoint.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        return (BaseOAuth20IntrospectionAccessTokenResponse)entity.getBody();
    }
}

