/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20RevocationEndpointController;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuthWeb")
public class OAuth20RevocationEndpointControllerTests
extends AbstractOAuth20Tests {
    private static final String PUBLIC_CLIENT_ID = "clientWithoutSecret";
    @Autowired
    @Qualifier(value="oauthRevocationController")
    private OAuth20RevocationEndpointController oAuth20RevocationController;

    @BeforeEach
    public void initialize() {
        this.clearAllServices();
    }

    @Test
    public void verifyNoGivenToken() throws Exception {
        this.servicesManager.save((RegisteredService)OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyGivenInvalidClientId() throws Exception {
        this.servicesManager.save((RegisteredService)OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "InvalidClientId");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("token", "AT-1234");
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyGivenInvalidClientSecret() throws Exception {
        this.servicesManager.save((RegisteredService)OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "wrongSecret");
        mockRequest.setParameter("token", "AT-1234");
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"access_denied", mv.getModel().get("error"));
    }

    @Test
    public void verifyGivenTokenNotInRegistry() throws Exception {
        this.servicesManager.save((RegisteredService)OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>()));
        this.servicesManager.save((RegisteredService)OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", PUBLIC_CLIENT_ID, "", new HashSet<OAuth20GrantTypes>()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("token", "AT-1234");
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
        mockRequest.removeAllParameters();
        mockRequest.setParameter("client_id", PUBLIC_CLIENT_ID);
        mockRequest.setParameter("token", "AT-1234");
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
    }

    @Test
    public void verifyGivenUnsupportedToken() throws Exception {
        Principal principal = OAuth20RevocationEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>());
        this.servicesManager.save((RegisteredService)service);
        OAuth20Code code = this.addCode(principal, service);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("token", code.getId());
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyGivenAccessTokenInRegistry() throws Exception {
        Principal principal = OAuth20RevocationEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>());
        OAuthRegisteredService publicService = OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", PUBLIC_CLIENT_ID, "", new HashSet<OAuth20GrantTypes>());
        this.servicesManager.save(new RegisteredService[]{service, publicService});
        OAuth20AccessToken accessToken = this.addAccessToken(principal, service);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(accessToken.getId()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("token", accessToken.getId());
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(accessToken.getId()));
        OAuth20AccessToken accessToken2 = this.addAccessToken(principal, publicService);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(accessToken2.getId()));
        mockRequest.removeAllParameters();
        mockRequest.setParameter("client_id", PUBLIC_CLIENT_ID);
        mockRequest.setParameter("token", accessToken2.getId());
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(accessToken2.getId()));
        OAuth20AccessToken accessToken3 = this.addAccessToken(principal, service);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(accessToken3.getId()));
        mockRequest.removeAllParameters();
        mockRequest.setParameter("client_id", PUBLIC_CLIENT_ID);
        mockRequest.setParameter("token", accessToken3.getId());
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    public void verifyGivenRefreshTokenInRegistry() throws Exception {
        Principal principal = OAuth20RevocationEndpointControllerTests.createPrincipal();
        OAuthRegisteredService service = OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", "secret", new HashSet<OAuth20GrantTypes>());
        OAuthRegisteredService publicService = OAuth20RevocationEndpointControllerTests.getRegisteredService("http://someurl", PUBLIC_CLIENT_ID, "", new HashSet<OAuth20GrantTypes>());
        this.servicesManager.save(new RegisteredService[]{service, publicService});
        OAuth20AccessToken accessToken = this.addAccessToken(principal, service);
        OAuth20RefreshToken refreshToken = this.addRefreshToken(principal, service, accessToken);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(accessToken.getId()));
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(refreshToken.getId()));
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.POST.name(), "/oauth2.0/revoke");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockRequest.setParameter("client_id", "1");
        mockRequest.setParameter("client_secret", "secret");
        mockRequest.setParameter("token", refreshToken.getId());
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(refreshToken.getId()));
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(accessToken.getId()));
        OAuth20AccessToken accessToken2 = this.addAccessToken(principal, publicService);
        OAuth20RefreshToken refreshToken2 = this.addRefreshToken(principal, publicService, accessToken2);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(accessToken2.getId()));
        mockRequest.removeAllParameters();
        mockRequest.setParameter("client_id", PUBLIC_CLIENT_ID);
        mockRequest.setParameter("token", refreshToken2.getId());
        this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)mockResponse.getStatus());
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(refreshToken2.getId()));
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(accessToken2.getId()));
        OAuth20RefreshToken refreshToken3 = this.addRefreshToken(principal, service);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(refreshToken3.getId()));
        mockRequest.removeAllParameters();
        mockRequest.setParameter("client_id", PUBLIC_CLIENT_ID);
        mockRequest.setParameter("token", refreshToken3.getId());
        ModelAndView mv = this.oAuth20RevocationController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)mockResponse.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }
}

