/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.metadata.BasicCredentialMetaData;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileEndpointController;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuthWeb")
public class OAuth20UserProfileEndpointControllerTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauth20ProtocolEndpointConfigurer")
    private ProtocolEndpointWebSecurityConfigurer<Void> oauth20ProtocolEndpointConfigurer;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private OAuth20AccessTokenFactory accessTokenFactory;
    @Autowired
    @Qualifier(value="oauthProfileController")
    private OAuth20UserProfileEndpointController oAuth20ProfileController;

    protected static Authentication getAuthentication(Principal principal) {
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)new BasicIdentifiableCredential(principal.getId()));
        DefaultAuthenticationHandlerExecutionResult handlerResult = new DefaultAuthenticationHandlerExecutionResult(principal.getClass().getCanonicalName(), (CredentialMetaData)metadata, principal, new ArrayList());
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).addCredential((CredentialMetaData)metadata).setAuthenticationDate(ZonedDateTime.now(ZoneId.systemDefault())).addSuccess(principal.getClass().getCanonicalName(), (AuthenticationHandlerExecutionResult)handlerResult).build();
    }

    @Test
    public void verifyNoGivenAccessToken() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handlePostRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        Assertions.assertNotNull((Object)entity.getBody());
        Assertions.assertTrue((boolean)entity.getBody().toString().contains("missing_accessToken"));
    }

    @Test
    public void verifyNoExistingAccessToken() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        mockRequest.setParameter("access_token", "DOES NOT EXIST");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        Assertions.assertNotNull((Object)entity.getBody());
        Assertions.assertTrue((boolean)entity.getBody().toString().contains("expired_accessToken"));
    }

    @Test
    public void verifyExpiredAccessToken() throws Exception {
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", new HashMap());
        Authentication authentication = OAuth20UserProfileEndpointControllerTests.getAuthentication(principal);
        JwtBuilder jwtBuilder = new JwtBuilder((CipherExecutor)new OAuth20JwtAccessTokenCipherExecutor(), this.servicesManager, (RegisteredServiceCipherExecutor)new OAuth20RegisteredServiceJwtAccessTokenCipherExecutor(), this.casProperties);
        OAuth20DefaultAccessTokenFactory expiringAccessTokenFactory = new OAuth20DefaultAccessTokenFactory(OAuth20UserProfileEndpointControllerTests.alwaysExpiresExpirationPolicyBuilder(), jwtBuilder, this.servicesManager);
        OAuth20Code code = this.addCode(principal, this.addRegisteredService());
        OAuth20AccessToken accessToken = expiringAccessTokenFactory.create((Service)RegisteredServiceTestUtils.getService(), authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        mockRequest.setParameter("access_token", accessToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        Assertions.assertNotNull((Object)entity.getBody());
        Assertions.assertTrue((boolean)entity.getBody().toString().contains("expired_accessToken"));
    }

    @Test
    public void verifyEndpoints() {
        Assertions.assertFalse((boolean)this.oauth20ProtocolEndpointConfigurer.getIgnoredEndpoints().isEmpty());
    }

    @Test
    public void verifyOK() throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("attributeName", List.of("attributeValue"));
        List<String> list = List.of("attributeValue", "attributeValue");
        map.put("attributeName2", list);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", map);
        Authentication authentication = OAuth20UserProfileEndpointControllerTests.getAuthentication(principal);
        OAuth20Code code = this.addCode(principal, this.addRegisteredService());
        OAuth20AccessToken accessToken = this.accessTokenFactory.create((Service)RegisteredServiceTestUtils.getService(), authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        mockRequest.setParameter("access_token", accessToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        String expected = "{\"id\":\"casuser\",\"attributes\":[{\"attributeName\":\"attributeValue\"},{\"attributeName2\":[\"attributeValue\",\"attributeValue\"]}]}";
        JsonNode expectedObj = MAPPER.readTree("{\"id\":\"casuser\",\"attributes\":[{\"attributeName\":\"attributeValue\"},{\"attributeName2\":[\"attributeValue\",\"attributeValue\"]}]}");
        JsonNode receivedObj = MAPPER.readTree(Objects.requireNonNull(entity.getBody()).toString());
        Assertions.assertEquals((Object)expectedObj.get("id").asText(), (Object)receivedObj.get("id").asText());
        JsonNode expectedAttributes = expectedObj.get("attributes");
        JsonNode receivedAttributes = receivedObj.get("attributes");
        Assertions.assertEquals((Object)expectedAttributes.findValue("attributeName").asText(), (Object)receivedAttributes.findValue("attributeName").asText());
        Assertions.assertEquals((Object)expectedAttributes.findValues("attributeName2"), (Object)receivedAttributes.findValues("attributeName2"));
    }

    @Test
    public void verifyOKWithExpiredTicketGrantingTicket() throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("attributeName", List.of("attributeValue"));
        List<String> list = List.of("attributeValue", "attributeValue");
        map.put("attributeName2", list);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", map);
        Authentication authentication = OAuth20UserProfileEndpointControllerTests.getAuthentication(principal);
        OAuth20Code code = this.addCode(principal, this.addRegisteredService());
        OAuth20AccessToken accessToken = this.accessTokenFactory.create((Service)RegisteredServiceTestUtils.getService(), authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        accessToken.getTicketGrantingTicket().markTicketExpired();
        this.ticketRegistry.addTicket((Ticket)accessToken);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        mockRequest.setParameter("access_token", accessToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        ObjectNode expectedObj = MAPPER.createObjectNode();
        ObjectNode attrNode = MAPPER.createObjectNode();
        attrNode.put("attributeName", "attributeValue");
        ArrayNode values = MAPPER.createArrayNode();
        values.add("attributeValue");
        values.add("attributeValue");
        attrNode.put("attributeName2", (JsonNode)values);
        expectedObj.put("id", "casuser");
        expectedObj.put("attributes", (JsonNode)attrNode);
        JsonNode receivedObj = MAPPER.readTree(entity.getBody().toString());
        Assertions.assertEquals((Object)expectedObj.get("id").asText(), (Object)receivedObj.get("id").asText());
        JsonNode expectedAttributes = expectedObj.get("attributes");
        JsonNode receivedAttributes = receivedObj.get("attributes");
        Assertions.assertEquals((Object)expectedAttributes.findValue("attributeName").asText(), (Object)receivedAttributes.findValue("attributeName").asText());
        Assertions.assertEquals((Object)expectedAttributes.findValues("attributeName2"), (Object)receivedAttributes.findValues("attributeName2"));
    }

    @Test
    public void verifyOKWithAuthorizationHeader() throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("attributeName", List.of("attributeValue"));
        List<String> list = List.of("attributeValue", "attributeValue");
        map.put("attributeName2", list);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", map);
        Authentication authentication = OAuth20UserProfileEndpointControllerTests.getAuthentication(principal);
        OAuth20Code code = this.addCode(principal, this.addRegisteredService());
        OAuth20AccessToken accessToken = this.accessTokenFactory.create((Service)RegisteredServiceTestUtils.getService(), authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/profile");
        mockRequest.addHeader("Authorization", (Object)("Bearer " + accessToken.getId()));
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oAuth20ProfileController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        Assertions.assertEquals((Object)"application/json", (Object)mockResponse.getContentType());
        String expected = "{\"id\":\"casuser\",\"attributes\":[{\"attributeName\":\"attributeValue\"},{\"attributeName2\":[\"attributeValue\",\"attributeValue\"]}]}";
        JsonNode expectedObj = MAPPER.readTree("{\"id\":\"casuser\",\"attributes\":[{\"attributeName\":\"attributeValue\"},{\"attributeName2\":[\"attributeValue\",\"attributeValue\"]}]}");
        JsonNode receivedObj = MAPPER.readTree(entity.getBody().toString());
        Assertions.assertEquals((Object)expectedObj.get("id").asText(), (Object)receivedObj.get("id").asText());
        JsonNode expectedAttributes = expectedObj.get("attributes");
        JsonNode receivedAttributes = receivedObj.get("attributes");
        Assertions.assertEquals((Object)expectedAttributes.findValue("attributeName").asText(), (Object)receivedAttributes.findValue("attributeName").asText());
        Assertions.assertEquals((Object)expectedAttributes.findValues("attributeName2"), (Object)receivedAttributes.findValues("attributeName2"));
    }
}

