/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.mgmt;

import java.util.LinkedHashSet;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.mgmt.OAuth20TokenManagementEndpoint;
import org.apereo.cas.ticket.Ticket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@TestPropertySource(properties={"management.endpoint.oauthTokens.enabled=true", "management.endpoints.web.exposure.include=*"})
@Tag(value="OAuthWeb")
public class OAuth20TokenManagementEndpointTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauth20TokenManagementEndpoint")
    private OAuth20TokenManagementEndpoint tokenManagementEndpoint;

    @Test
    public void verifyOperationWithJwt() throws Exception {
        OAuthRegisteredService registeredService = OAuth20TokenManagementEndpointTests.getRegisteredService("example1", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        String at = mv.getModel().get("access_token").toString();
        Ticket token = this.tokenManagementEndpoint.getToken(at);
        Assertions.assertNotNull((Object)token);
        Assertions.assertFalse((boolean)this.tokenManagementEndpoint.getTokens().isEmpty());
        this.tokenManagementEndpoint.deleteToken(token.getId());
    }

    @Test
    public void verifyOperation() {
        OAuthRegisteredService registeredService = OAuth20TokenManagementEndpointTests.getRegisteredService("example2", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        String at = mv.getModel().get("access_token").toString();
        Ticket token = this.tokenManagementEndpoint.getToken(at);
        Assertions.assertNotNull((Object)token);
    }

    @Test
    public void verifyBadOperation() {
        Assertions.assertNull((Object)this.tokenManagementEndpoint.getToken("unknown"));
    }
}

