/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.util.LinkedHashSet;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenAtHashGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuth")
public class OAuth20AccessTokenAtHashGeneratorTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyNoneAlgorithm() {
        String hash = this.generateHashWithAlgorithm("none");
        Assertions.assertEquals((Object)"QVQtMTIzNDU2", (Object)hash);
    }

    private String generateHashWithAlgorithm(String alg) {
        OAuth20AccessToken accessToken = OAuth20AccessTokenAtHashGeneratorTests.getAccessToken();
        OAuthRegisteredService registeredService = OAuth20AccessTokenAtHashGeneratorTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        String encodedAccessToken = (String)OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)registeredService).service(accessToken.getService()).casProperties(this.casProperties).accessTokenJwtBuilder(this.accessTokenJwtBuilder).build().encode((Object)accessToken.getId());
        return OAuth20AccessTokenAtHashGenerator.builder().algorithm(alg).registeredService((RegisteredService)registeredService).encodedAccessToken(encodedAccessToken).build().generate();
    }

    @Test
    public void verifySha512Algorithm() {
        String hash = this.generateHashWithAlgorithm("RS512");
        Assertions.assertEquals((Object)"EZsVCVYBY_zw4RAkJ3s759RxOZ8UingrP-52KQX4G6E", (Object)hash);
    }

    @Test
    public void verifySha256Algorithm() {
        String hash = this.generateHashWithAlgorithm("RS256");
        Assertions.assertEquals((Object)"IzG3xSUlcgF_gHDCvKd3fQ", (Object)hash);
    }

    @Test
    public void verifySha384Algorithm() {
        String hash = this.generateHashWithAlgorithm("RS384");
        Assertions.assertEquals((Object)"9Kb1tRRQ1YATHOB95-YAH3LHmnF2Lu7l", (Object)hash);
    }

    @Test
    public void verifyUnknownAlgorithm() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.generateHashWithAlgorithm("xyz"));
    }
}

