/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.DefaultDPoPProofFactory;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPTokenRequestVerifier;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuth")
public class OAuth20DefaultAccessTokenResponseGeneratorTests
extends AbstractOAuth20Tests {
    @BeforeEach
    public void initialize() {
        this.clearAllServices();
    }

    @Test
    public void verifyAccessTokenAsDefault() {
        OAuthRegisteredService registeredService = OAuth20DefaultAccessTokenResponseGeneratorTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(false);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        Map model = mv.getModel();
        Assertions.assertTrue((boolean)model.containsKey("access_token"));
        Assertions.assertTrue((boolean)model.containsKey("expires_in"));
        Assertions.assertTrue((boolean)model.containsKey("scope"));
        Assertions.assertTrue((boolean)model.containsKey("token_type"));
        Assertions.assertThrows(ParseException.class, () -> {
            String at = model.get("access_token").toString();
            JWTParser.parse((String)at);
        });
    }

    @Test
    public void verifyAccessTokenAsJwt() throws Exception {
        OAuthRegisteredService registeredService = OAuth20DefaultAccessTokenResponseGeneratorTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String at = mv.getModel().get("access_token").toString();
        JWT jwt = JWTParser.parse((String)at);
        Assertions.assertNotNull((Object)jwt);
    }

    @Test
    public void verifyDPoPAccessTokenAsJwt() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        OAuthRegisteredService registeredService = OAuth20DefaultAccessTokenResponseGeneratorTests.getRegisteredService("example", UUID.randomUUID().toString(), "secret");
        this.servicesManager.save((RegisteredService)registeredService);
        ECKey ecJWK = (ECKey)new ECKeyGenerator(Curve.P_256).keyID("1").generate();
        DefaultDPoPProofFactory proofFactory = new DefaultDPoPProofFactory((JWK)ecJWK, JWSAlgorithm.ES256);
        SignedJWT signedProof = proofFactory.createDPoPJWT("POST", new URI(mockRequest.getRequestURL().toString()));
        DPoPIssuer dPopIssuer = new DPoPIssuer(new ClientID(registeredService.getClientId()));
        DPoPTokenRequestVerifier verifier = new DPoPTokenRequestVerifier(Set.of(JWSAlgorithm.ES256), new URI(mockRequest.getRequestURL().toString()), 30L, null);
        JWKThumbprintConfirmation confirmation = verifier.verify(dPopIssuer, signedProof);
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", Map.of("DPoP", List.of(signedProof.serialize()), "DPoPConfirmation", List.of(confirmation.getValue().toString())));
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService, authentication, OAuth20GrantTypes.AUTHORIZATION_CODE, (HttpServletRequest)mockRequest);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("token_type"));
        Assertions.assertEquals((Object)"DPoP", mv.getModel().get("token_type"));
        String at = mv.getModel().get("access_token").toString();
        JWT jwt = JWTParser.parse((String)at);
        Assertions.assertNotNull((Object)jwt);
    }

    @Test
    public void verifyAccessTokenAsJwtPerService() throws Exception {
        OAuthRegisteredService registeredService = OAuth20DefaultAccessTokenResponseGeneratorTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        DefaultRegisteredServiceProperty signingKey = new DefaultRegisteredServiceProperty();
        signingKey.addValue("pR3Vizkn5FSY5xCg84cIS4m-b6jomamZD68C8ash-TlNmgGPcoLgbgquxHPoi24tRmGpqHgM4mEykctcQzZ-Xg");
        registeredService.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_KEY.getPropertyName(), signingKey);
        DefaultRegisteredServiceProperty encKey = new DefaultRegisteredServiceProperty();
        encKey.addValue("0KVXaN-nlXafRUwgsr3H_l6hkufY7lzoTy7OVI5pN0E");
        registeredService.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY.getPropertyName(), encKey);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String at = mv.getModel().get("access_token").toString();
        JWT jwt = JWTParser.parse((String)at);
        Assertions.assertNotNull((Object)jwt);
    }
}

