/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.util.LinkedHashSet;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20DefaultTokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuthToken")
@TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption.key=AZ5y4I9qzKPYUVNL2Td4RMbpg6Z-ldui8VEFg8hsj1M", "cas.authn.oauth.access-token.crypto.signing.key=cAPyoHMrOMWrwydOXzBA-ufZQM-TilnLjbRgMQWlUlwFmy07bOtAgCIdNBma3c5P4ae_JV6n1OpOAYqSh2NkmQ", "cas.authn.oauth.access-token.crypto.enabled=true", "cas.authn.oauth.device-token.refresh-interval=PT1S"})
public class OAuth20DefaultTokenGeneratorTests
extends AbstractOAuth20Tests {
    @BeforeEach
    public void initialize() {
        this.clearAllServices();
    }

    @Test
    public void verifyRequestedClaims() throws Exception {
        OAuthRegisteredService registeredService = OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret", new LinkedHashSet<OAuth20GrantTypes>());
        this.servicesManager.save((RegisteredService)registeredService);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        String claims = "\"userinfo\": {\"given_name\": {\"essential\": true}}";
        mockRequest.addParameter("claims", "\"userinfo\": {\"given_name\": {\"essential\": true}}");
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService, RegisteredServiceTestUtils.getAuthentication((String)"casuser"), OAuth20GrantTypes.AUTHORIZATION_CODE, (HttpServletRequest)mockRequest);
        Assertions.assertNotNull((Object)mv);
        String id = mv.getModel().get("access_token").toString();
        OAuth20AccessToken at = (OAuth20AccessToken)this.ticketRegistry.getTicket(id, OAuth20AccessToken.class);
        Assertions.assertTrue((boolean)at.getAuthentication().getAttributes().containsKey("given_name"));
    }

    @Test
    public void verifyAccessTokenAsJwt() throws Exception {
        OAuthRegisteredService registeredService = OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String at = mv.getModel().get("access_token").toString();
        String decoded = this.oauthAccessTokenJwtCipherExecutor.decode((Object)at).toString();
        Assertions.assertNotNull((Object)decoded);
        JwtClaims jwt = JwtClaims.parse((String)decoded);
        Assertions.assertNotNull((Object)jwt);
        String ticketId = jwt.getJwtId();
        Assertions.assertNotNull((Object)ticketId);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(ticketId, OAuth20AccessToken.class));
    }

    @Test
    public void verifySlowDown() throws Exception {
        OAuth20DefaultTokenGenerator generator = new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory, this.defaultDeviceTokenFactory, this.defaultDeviceUserCodeFactory, this.oAuthRefreshTokenFactory, this.ticketRegistry, this.casProperties);
        OAuth20DeviceToken token = this.defaultDeviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService((String)"https://device.oauth.org"));
        this.ticketRegistry.addTicket((Ticket)token);
        OAuth20DeviceUserCode userCode = this.defaultDeviceUserCodeFactory.createDeviceUserCode(token);
        this.ticketRegistry.addTicket((Ticket)userCode);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(token.getId()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService(OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret")).build();
        Assertions.assertThrows(ThrottledOAuth20DeviceUserCodeApprovalException.class, () -> generator.generate(holder));
    }

    @Test
    public void verifyUnapproved() throws Exception {
        OAuth20DefaultTokenGenerator generator = new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory, this.defaultDeviceTokenFactory, this.defaultDeviceUserCodeFactory, this.oAuthRefreshTokenFactory, this.ticketRegistry, this.casProperties);
        OAuth20DeviceToken token = this.defaultDeviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService((String)"https://device.oauth.org"));
        this.ticketRegistry.addTicket((Ticket)token);
        OAuth20DeviceUserCode userCode = this.defaultDeviceUserCodeFactory.createDeviceUserCode(token);
        this.ticketRegistry.addTicket((Ticket)userCode);
        Thread.sleep(2000L);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(token.getId()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService(OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret")).build();
        Assertions.assertThrows(UnapprovedOAuth20DeviceUserCodeException.class, () -> generator.generate(holder));
    }

    @Test
    public void verifyExpiredUserCode() throws Exception {
        OAuth20DefaultTokenGenerator generator = new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory, this.defaultDeviceTokenFactory, this.defaultDeviceUserCodeFactory, this.oAuthRefreshTokenFactory, this.ticketRegistry, this.casProperties);
        OAuth20DeviceToken token = this.defaultDeviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService((String)"https://device.oauth.org"));
        this.ticketRegistry.addTicket((Ticket)token);
        OAuth20DeviceUserCode userCode = this.defaultDeviceUserCodeFactory.createDeviceUserCode(token);
        this.ticketRegistry.addTicket((Ticket)userCode);
        Thread.sleep(2000L);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(token.getId()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService(OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret")).build();
        userCode.markTicketExpired();
        Assertions.assertThrows(InvalidOAuth20DeviceTokenException.class, () -> generator.generate(holder));
    }

    @Test
    public void verifyDeviceCodeExpired() throws Exception {
        OAuth20DefaultTokenGenerator generator = new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory, this.defaultDeviceTokenFactory, this.defaultDeviceUserCodeFactory, this.oAuthRefreshTokenFactory, this.ticketRegistry, this.casProperties);
        OAuth20DeviceToken token = this.defaultDeviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService((String)"https://device.oauth.org"));
        this.ticketRegistry.addTicket((Ticket)token);
        OAuth20DeviceUserCode userCode = this.defaultDeviceUserCodeFactory.createDeviceUserCode(token);
        this.ticketRegistry.addTicket((Ticket)userCode);
        Thread.sleep(2000L);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(token.getId()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService(OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret")).build();
        token.markTicketExpired();
        Assertions.assertThrows(InvalidOAuth20DeviceTokenException.class, () -> generator.generate(holder));
    }

    @Test
    public void verifyAccessTokenIsRefreshed() throws Exception {
        OAuthRegisteredService registeredService = OAuth20DefaultTokenGeneratorTests.getRegisteredService(UUID.randomUUID().toString(), "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication((String)"casuser");
        ModelAndView mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService, authentication, OAuth20GrantTypes.AUTHORIZATION_CODE);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String at = mv.getModel().get("access_token").toString();
        String decoded = this.oauthAccessTokenJwtCipherExecutor.decode((Object)at).toString();
        Assertions.assertNotNull((Object)decoded);
        JwtClaims jwt = JwtClaims.parse((String)decoded);
        Assertions.assertNotNull((Object)jwt);
        Assertions.assertNotNull((Object)jwt.getIssuedAt());
        Assertions.assertNotEquals((long)authentication.getAuthenticationDate().toInstant().toEpochMilli(), (long)jwt.getIssuedAt().getValueInMillis());
        Assertions.assertNotNull((Object)jwt.getExpirationTime());
        Thread.sleep(2000L);
        mv = this.generateAccessTokenResponseAndGetModelAndView(registeredService, authentication, OAuth20GrantTypes.REFRESH_TOKEN);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        String refreshedAt = mv.getModel().get("access_token").toString();
        String refreshedDecoded = this.oauthAccessTokenJwtCipherExecutor.decode((Object)refreshedAt).toString();
        Assertions.assertNotNull((Object)refreshedDecoded);
        JwtClaims refreshedJwt = JwtClaims.parse((String)refreshedDecoded);
        Assertions.assertNotNull((Object)refreshedJwt);
        Assertions.assertNotNull((Object)refreshedJwt.getIssuedAt());
        Assertions.assertNotEquals((long)authentication.getAuthenticationDate().toInstant().toEpochMilli(), (long)refreshedJwt.getIssuedAt().getValueInMillis());
        Assertions.assertNotNull((Object)refreshedJwt.getExpirationTime());
        Assertions.assertNotEquals((long)jwt.getExpirationTime().getValue(), (long)refreshedJwt.getExpirationTime().getValue());
    }
}

