/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.util.LinkedHashSet;
import java.util.Map;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20JwtAccessTokenEncoderTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyAccessTokenHeaderService() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuth20JwtBuilder builder = this.getCipherDisabledJwtBuilder();
        OAuthRegisteredService registeredService = OAuth20JwtAccessTokenEncoderTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setId(100200L);
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken);
        encoder = this.getAccessTokenEncoder(accessToken, builder, null);
        encoder.decode((Object)encodedAccessToken);
    }

    @Test
    public void verifyAccessTokenIdEncodingWithoutJwt() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuth20JwtBuilder builder = this.getCipherDisabledJwtBuilder();
        OAuthRegisteredService registeredService = OAuth20JwtAccessTokenEncoderTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        String encodedAccessToken1 = (String)this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken1);
        String encodedAccessToken2 = (String)this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        Assertions.assertEquals((Object)encodedAccessToken1, (Object)encodedAccessToken2);
    }

    @Test
    public void verifyAccessTokenIdEncodingWithJwtWithNoCipher() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithoutKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherDisabledJwtBuilder();
        String encodedAccessToken1 = (String)this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken1);
        String encodedAccessToken2 = (String)this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        Assertions.assertEquals((Object)encodedAccessToken1, (Object)encodedAccessToken2);
    }

    @Test
    public void verifyAccessTokenIdEncodingWithJwtGlobally() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithoutKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherEnabledJwtBuilder();
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken);
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    public void verifyExtractionAsParameterForService() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherEnabledJwtBuilder();
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    public void verifyExtractionAsParameter() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithoutKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherEnabledJwtBuilder();
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    public void verifyAccessTokenIdEncodingWithJwtForService() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherEnabledJwtBuilder();
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken);
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    public void verifyAccessTokenIdEncodingWithJwt() {
        OAuth20AccessToken accessToken = OAuth20JwtAccessTokenEncoderTests.getAccessToken();
        OAuthRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtBuilder builder = this.getCipherEnabledJwtBuilder();
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, builder, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        Assertions.assertNotNull((Object)encodedAccessToken);
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    private OAuth20JwtAccessTokenEncoder getAccessTokenEncoder(OAuth20AccessToken accessToken, OAuth20JwtBuilder builder, RegisteredService registeredService) {
        return OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService(registeredService).service(accessToken.getService()).accessTokenJwtBuilder((JwtBuilder)builder).casProperties(this.casProperties).build();
    }

    private OAuth20JwtBuilder getCipherDisabledJwtBuilder() {
        return new OAuth20JwtBuilder(CipherExecutor.noOp(), this.servicesManager, RegisteredServiceCipherExecutor.noOp(), this.casProperties);
    }

    private OAuthRegisteredService getRegisteredServiceForJwtAccessTokenWithoutKeys(OAuth20AccessToken accessToken) {
        OAuthRegisteredService registeredService = OAuth20JwtAccessTokenEncoderTests.getRegisteredService(accessToken.getService().getId(), "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }

    private OAuth20JwtBuilder getCipherEnabledJwtBuilder() {
        return new OAuth20JwtBuilder((CipherExecutor)new OAuth20JwtAccessTokenCipherExecutor(true, true), this.servicesManager, (RegisteredServiceCipherExecutor)new OAuth20RegisteredServiceJwtAccessTokenCipherExecutor(), this.casProperties);
    }

    private OAuthRegisteredService getRegisteredServiceForJwtAccessTokenWithKeys(OAuth20AccessToken accessToken) {
        OAuthRegisteredService registeredService = OAuth20JwtAccessTokenEncoderTests.getRegisteredService(accessToken.getService().getId(), "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"true"}), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"true"}), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"1PbwSbnHeinpkZOSZjuSJ8yYpUrInm5aaV18J2Ar4rM"}), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_KEY.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"szxK-5_eJjs-aUj-64MpUZ-GPPzGLhYPLGl0wrYjYNVAGva2P0lLe6UGKGM7k8dWxsOVGutZWgvmY3l5oVPO3w"})));
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }
}

