/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class AccessTokenAuthorizationCodeGrantRequestExtractorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="accessTokenAuthorizationCodeGrantRequestExtractor")
    private AccessTokenGrantRequestExtractor extractor;

    @Test
    public void verifyNoToken() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        request.addParameter("redirect_uri", "http://someurl");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        this.servicesManager.save((RegisteredService)service);
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertEquals((Object)OAuth20ResponseTypes.NONE, (Object)this.extractor.getResponseType());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertThrows(InvalidTicketException.class, () -> this.extractor.extract((WebContext)context));
    }

    @Test
    public void verifyDPoPRequest() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "http://someurl");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("client_id", "1");
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        service.setGenerateRefreshToken(true);
        this.servicesManager.save((RegisteredService)service);
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        this.ticketRegistry.addTicket((Ticket)code.getTicketGrantingTicket());
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, this.oauthDistributedSessionStore);
        profileManager.removeProfiles();
        CommonProfile commonProfile = new CommonProfile();
        commonProfile.setId(service.getClientId());
        commonProfile.addAttribute("DPoP", (Object)"dpop-value");
        commonProfile.addAttribute("DPoPConfirmation", (Object)"dpop-confirmation-value");
        profileManager.save(true, (UserProfile)commonProfile, false);
        AccessTokenRequestContext result = this.extractor.extract((WebContext)context);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)result.getDpop());
        Assertions.assertNotNull((Object)result.getDpopConfirmation());
    }

    @Test
    public void verifyExtraction() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "http://someurl");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("client_id", "1");
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        service.setGenerateRefreshToken(true);
        this.servicesManager.save((RegisteredService)service);
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        this.ticketRegistry.addTicket((Ticket)code.getTicketGrantingTicket());
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        AccessTokenRequestContext result = this.extractor.extract((WebContext)context);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void verifyExpiredCode() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "http://someurl");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("client_id", "1");
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        service.setGenerateRefreshToken(true);
        this.servicesManager.save((RegisteredService)service);
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        this.ticketRegistry.addTicket((Ticket)code.getTicketGrantingTicket());
        code.markTicketExpired();
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertThrows(InvalidTicketException.class, () -> this.extractor.extract((WebContext)context));
    }

    @Test
    public void verifyExpiredTgt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "http://someurl");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("client_id", "1");
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        service.setGenerateRefreshToken(true);
        this.servicesManager.save((RegisteredService)service);
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        code.getTicketGrantingTicket().markTicketExpired();
        this.ticketRegistry.updateTicket((Ticket)code);
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertThrows(InvalidTicketException.class, () -> this.extractor.extract((WebContext)context));
    }

    @Test
    public void verifyUnknownService() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "unknown.org/abc");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("client_id", "Unknown");
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        this.ticketRegistry.addTicket((Ticket)code.getTicketGrantingTicket());
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.extractor.extract((WebContext)context));
    }

    @Test
    public void verifyNoClientIdOrRedirectUri() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        OAuthRegisteredService service = AccessTokenAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        this.ticketRegistry.addTicket((Ticket)code.getTicketGrantingTicket());
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.extractor.extract((WebContext)context));
    }
}

