/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauth20ConfigurationContext")
    private OAuth20ConfigurationContext oauth20ConfigurationContext;

    @Test
    public void verifyExtraction() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("code_verifier", "code-verifier");
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("code_challenge", "challenge");
        request.addParameter("client_id", "1");
        OAuthRegisteredService service = AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractorTests.getRegisteredService("http://someurl", "1", "secret");
        this.servicesManager.save((RegisteredService)service);
        Principal principal = RegisteredServiceTestUtils.getPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        request.addParameter("code", code.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor extractor = new AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor(this.oauth20ConfigurationContext);
        Assertions.assertTrue((boolean)extractor.requestMustBeAuthenticated());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        AccessTokenRequestContext result = extractor.extract((WebContext)context);
        Assertions.assertNotNull((Object)result);
    }
}

