/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRefreshTokenGrantRequestExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class AccessTokenRefreshTokenGrantRequestExtractorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauth20ConfigurationContext")
    private OAuth20ConfigurationContext oauth20ConfigurationContext;

    @Test
    public void verifyNoService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuthRegisteredService service = AccessTokenRefreshTokenGrantRequestExtractorTests.getRegisteredService(UUID.randomUUID().toString(), UUID.randomUUID().toString(), "secret");
        request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.getType());
        request.addParameter("client_id", service.getClientId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        AccessTokenRefreshTokenGrantRequestExtractor extractor = new AccessTokenRefreshTokenGrantRequestExtractor(this.oauth20ConfigurationContext);
        Assertions.assertEquals((Object)OAuth20ResponseTypes.NONE, (Object)extractor.getResponseType());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)extractor.supports((WebContext)context));
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> extractor.extract((WebContext)context));
    }
}

