/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuth")
public class DefaultOAuth20AuthorizationModelAndViewBuilderTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthAuthorizationModelAndViewBuilder")
    private OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder;

    @Test
    public void verifyFragment() throws Exception {
        OAuthRegisteredService registeredService = DefaultOAuth20AuthorizationModelAndViewBuilderTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.oauthAuthorizationModelAndViewBuilder.build(registeredService, OAuth20ResponseModeTypes.FRAGMENT, "https://github.com/apereo/cas?one=value&two=value&code=123456", Map.of("code", "123456"));
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
        RedirectView view = (RedirectView)mv.getView();
        Assertions.assertTrue((boolean)mv.getModel().isEmpty());
        Assertions.assertEquals((Object)"code=123456", (Object)new URI(view.getUrl()).getFragment());
    }
}

