/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuth")
public class OAuth20AuthorizationCodeAuthorizationResponseBuilderTests
extends AbstractOAuth20Tests {
    private static final String STATE = UUID.randomUUID().toString();
    private static final String NONCE = UUID.randomUUID().toString();

    @Test
    public void verifyOperation() throws Exception {
        OAuthRegisteredService registeredService = OAuth20AuthorizationCodeAuthorizationResponseBuilderTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        this.servicesManager.save((RegisteredService)registeredService);
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("state", Collections.singletonList(STATE));
        attributes.put("nonce", Collections.singletonList(NONCE));
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication((Principal)RegisteredServiceTestUtils.getPrincipal((String)"casuser"), attributes);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).authentication(authentication).registeredService(registeredService).responseType(OAuth20ResponseTypes.CODE).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket(authentication)).service((Service)RegisteredServiceTestUtils.getService((String)"example")).redirectUri("https://github.com/apereo/cas").build();
        ModelAndView mv = this.oauthAuthorizationCodeResponseBuilder.build(holder);
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("code"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("state"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("nonce"));
        String code = mv.getModel().get("code").toString();
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(code, OAuth20Code.class));
        OAuth20AuthorizationRequest authzRequest = OAuth20AuthorizationRequest.builder().responseType(OAuth20ResponseTypes.CODE.getType()).clientId(holder.getClientId()).build();
        Assertions.assertTrue((boolean)this.oauthAuthorizationCodeResponseBuilder.supports(authzRequest));
    }
}

