/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuth")
public class OAuth20InvalidAuthorizationResponseBuilderTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthInvalidAuthorizationBuilder")
    private OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder;

    @Test
    public void verifyRequestWithoutCallback() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        context.setRequestAttribute("error", (Object)"invalid_request");
        Assertions.assertTrue((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        Assertions.assertEquals((Object)"error/casServiceErrorView", (Object)this.oauthInvalidAuthorizationBuilder.build(context).getViewName());
        context.setRequestAttribute("error_with_callback", (Object)false);
        Assertions.assertEquals((Object)"error/casServiceErrorView", (Object)this.oauthInvalidAuthorizationBuilder.build(context).getViewName());
    }

    @Test
    public void verifyRequestWithCallbackAndDescription() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        request.addParameter("redirect_uri", "https://github.com/apereo/cas");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        context.setRequestAttribute("error", (Object)"invalid_request");
        context.setRequestAttribute("error_description", (Object)"Invalid Request Description");
        context.setRequestAttribute("error_with_callback", (Object)true);
        Assertions.assertTrue((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        ModelAndView mv = this.oauthInvalidAuthorizationBuilder.build(context);
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
        RedirectView mvView = (RedirectView)mv.getView();
        Assertions.assertEquals((Object)"https://github.com/apereo/cas", (Object)mvView.getUrl());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error_description"));
        Assertions.assertFalse((boolean)mv.getModel().containsKey("state"));
        String error = mv.getModel().get("error").toString();
        Assertions.assertEquals((Object)"invalid_request", (Object)error);
        String errorDescription = mv.getModel().get("error_description").toString();
        Assertions.assertEquals((Object)"Invalid Request Description", (Object)errorDescription);
    }

    @Test
    public void verifyRequestWithCallbackWithoutDescription() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        request.addParameter("redirect_uri", "https://github.com/apereo/cas");
        request.addParameter("state", "abcdefgh");
        request.addParameter("response_mode", OAuth20ResponseModeTypes.FORM_POST.getType());
        request.addParameter("ParameterWhichShouldNotComingBack", "notAtAll");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        context.setRequestAttribute("error", (Object)"invalid_request");
        context.setRequestAttribute("error_with_callback", (Object)true);
        Assertions.assertTrue((boolean)this.oauthInvalidAuthorizationBuilder.supports(context));
        ModelAndView mv = this.oauthInvalidAuthorizationBuilder.build(context);
        Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("originalUrl"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("parameters"));
        Object originalUrl = mv.getModel().get("originalUrl");
        Assertions.assertEquals((Object)"https://github.com/apereo/cas", originalUrl);
        Map parameters = (Map)mv.getModel().get("parameters");
        Assertions.assertTrue((boolean)parameters.containsKey("error"));
        Assertions.assertFalse((boolean)parameters.containsKey("error_description"));
        Assertions.assertTrue((boolean)parameters.containsKey("state"));
        Assertions.assertEquals((Object)"invalid_request", parameters.get("error"));
        Assertions.assertEquals((Object)"abcdefgh", parameters.get("state"));
    }
}

