/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Map;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuth")
public class OAuth20ResourceOwnerCredentialsResponseBuilderTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperation() throws Exception {
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId("1").service(CoreAuthenticationTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication((Principal)CoreAuthenticationTestUtils.getPrincipal((String)"casuser"))).registeredService(OAuth20ResourceOwnerCredentialsResponseBuilderTests.getRegisteredService("1", "secret")).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).build();
        Assertions.assertNotNull((Object)this.oauthResourceOwnerCredentialsResponseBuilder.build(holder));
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"1");
        Assertions.assertNotNull((Object)this.oauthResourceOwnerCredentialsResponseBuilder.build(registeredService, OAuth20ResponseModeTypes.FORM_POST, "https://example.org", Map.of()));
    }

    @Test
    public void verifyModelAndViewPost() throws Exception {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"1");
        Assertions.assertNotNull((Object)this.oauthResourceOwnerCredentialsResponseBuilder.build(registeredService, OAuth20ResponseModeTypes.FORM_POST, "https://example.org", Map.of("key", "value")));
    }

    @Test
    public void verifyModelAndView() throws Exception {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"1");
        Assertions.assertNotNull((Object)this.oauthResourceOwnerCredentialsResponseBuilder.build(registeredService, OAuth20ResponseModeTypes.FORM_POST, "https://example.org", Map.of("key", "value")));
    }
}

