/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OAuth")
public class OAuth20TokenAuthorizationResponseBuilderTests
extends AbstractOAuth20Tests {
    private static final String STATE = "%123=";
    private static final String NONCE = "%123=";

    private static void verifyParam(Map<String, List<String>> params, String paramName, String expectedParamValue) {
        Assertions.assertTrue((boolean)params.containsKey(paramName), () -> "Expected " + paramName + "  param in redirect URL");
        Assertions.assertEquals((int)1, (int)params.get(paramName).size(), () -> "Expected one value for " + paramName + " param");
        Assertions.assertEquals((Object)expectedParamValue, (Object)params.get(paramName).get(0), () -> "Expected unchanged " + paramName + "  param");
    }

    private static Map<String, List<String>> splitQuery(String fragment) {
        if (StringUtils.isBlank((CharSequence)fragment)) {
            return new HashMap<String, List<String>>(0);
        }
        return Arrays.stream(fragment.split("&")).map(OAuth20TokenAuthorizationResponseBuilderTests::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf(61);
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    @Test
    public void verifyUnchangedStateAndNonceParameter() throws Exception {
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.oauthAuthorizationCodeResponseBuilder.getOrder());
        OAuthRegisteredService registeredService = OAuth20TokenAuthorizationResponseBuilderTests.getRegisteredService("example", "secret", new LinkedHashSet<OAuth20GrantTypes>());
        registeredService.setJwtAccessToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"example");
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("state", Collections.singletonList("%123="));
        attributes.put("nonce", Collections.singletonList("%123="));
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)service).authentication(RegisteredServiceTestUtils.getAuthentication((Principal)RegisteredServiceTestUtils.getPrincipal((String)"casuser"), attributes)).registeredService(registeredService).grantType(OAuth20GrantTypes.NONE).responseType(OAuth20ResponseTypes.TOKEN).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).generateRefreshToken(true).redirectUri("https://oauth.example.org").build();
        ModelAndView modelAndView = this.oauthTokenResponseBuilder.build(holder);
        Assertions.assertTrue((boolean)(modelAndView.getView() instanceof RedirectView), (String)"Expected RedirectView");
        Assertions.assertTrue((boolean)modelAndView.getModel().isEmpty());
        String redirectUrl = ((RedirectView)modelAndView.getView()).getUrl();
        Map<String, List<String>> params = OAuth20TokenAuthorizationResponseBuilderTests.splitQuery(new URIBuilder(redirectUrl).getFragment());
        OAuth20TokenAuthorizationResponseBuilderTests.verifyParam(params, "state", "%123=");
        OAuth20TokenAuthorizationResponseBuilderTests.verifyParam(params, "nonce", "%123=");
    }
}

