/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.hjson.JsonObject;
import org.hjson.JsonValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuth")
@TestPropertySource(properties={"cas.authn.oauth.core.user-profile-view-type=FLAT"})
public class OAuth20DefaultUserProfileViewRendererFlatTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthUserProfileViewRenderer")
    private OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer;

    @Test
    public void verifyNestedOption() {
        Map map = CollectionUtils.wrap((String)"id", (Object)"cas", (String)"attributes", (Object)CollectionUtils.wrap((String)"email", (Object)"cas@example.org", (String)"name", (Object)"Test"), (String)"something", (Object)CollectionUtils.wrapList((Object[])new String[]{"something"}));
        ResponseEntity json = this.oauthUserProfileViewRenderer.render(map, (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class), (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertNotNull((Object)json.getBody());
        JsonObject value = JsonValue.readJSON((String)json.getBody().toString()).asObject();
        Assertions.assertNotNull((Object)value.get("id"));
        Assertions.assertNotNull((Object)value.get("email"));
        Assertions.assertNotNull((Object)value.get("name"));
        Assertions.assertNull((Object)value.get("attributes"));
    }
}

