/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasOAuth20AuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasOAuth20ComponentSerializationConfiguration;
import org.apereo.cas.config.CasOAuth20Configuration;
import org.apereo.cas.config.CasOAuth20EndpointsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasOAuth20Configuration.class, CasOAuth20EndpointsConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCookieConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreWebConfiguration.class, CasCoreUtilConfiguration.class, CasCoreHttpConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreLogoutConfiguration.class, CasOAuth20ComponentSerializationConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasOAuth20AuthenticationServiceSelectionStrategyConfiguration.class})
public abstract class BaseOAuth20ExpirationPolicyTests {
    protected static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "oAuthTokenExpirationPolicy.json");
    protected static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator(64L);
    private static final ExpirationPolicy EXP_POLICY_TGT = new HardTimeoutExpirationPolicy(1000L);
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    protected OAuth20AccessTokenFactory defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="defaultRefreshTokenFactory")
    protected OAuth20RefreshTokenFactory defaultRefreshTokenFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;

    protected static TicketGrantingTicket newTicketGrantingTicket() {
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        return new TicketGrantingTicketImpl(ID_GENERATOR.getNewTicketId("TGT"), CoreAuthenticationTestUtils.getAuthentication((Principal)principal), EXP_POLICY_TGT);
    }

    protected OAuth20Code createOAuthCode() {
        ExpirationPolicyBuilder builder = (ExpirationPolicyBuilder)Mockito.mock(ExpirationPolicyBuilder.class);
        Mockito.when((Object)builder.buildTicketExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return new OAuth20DefaultOAuthCodeFactory((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), builder, this.servicesManager, CipherExecutor.noOpOfStringToString()).create((Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), (Collection)CollectionUtils.wrapSet((Object[])new String[]{"1", "2"}), "code-challenge", "code-challenge-method", "clientId1234567", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
    }

    protected OAuth20AccessToken newAccessToken(TicketGrantingTicket tgt) {
        OAuth20Code code = this.createOAuthCode();
        Service testService = CoreAuthenticationTestUtils.getService((String)"https://service.example.com");
        return this.defaultAccessTokenFactory.create(testService, tgt.getAuthentication(), tgt, new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
    }

    protected OAuth20RefreshToken newRefreshToken(OAuth20AccessToken at) {
        Service testService = CoreAuthenticationTestUtils.getService((String)"https://service.example.com");
        OAuth20RefreshToken rt = this.defaultRefreshTokenFactory.create(testService, at.getAuthentication(), at.getTicketGrantingTicket(), new ArrayList(), "clientid12345", at.getId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        at.getTicketGrantingTicket().getDescendantTickets().add(rt.getId());
        return rt;
    }
}

