/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.security.PublicKey;
import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.ticket.BaseTokenSigningAndEncryptionService;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OAuth")
public class TokenSigningAndEncryptionServiceTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperation() {
        PublicJsonWebKey publicKey = (PublicJsonWebKey)Mockito.mock(PublicJsonWebKey.class);
        Mockito.when((Object)publicKey.getPublicKey()).thenReturn(null);
        BaseTokenSigningAndEncryptionService service = (BaseTokenSigningAndEncryptionService)Mockito.mock(BaseTokenSigningAndEncryptionService.class);
        Mockito.when((Object)service.decode(Mockito.anyString(), (Optional)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)service.getJsonWebKeySigningKey()).thenReturn((Object)publicKey);
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.decode(UUID.randomUUID().toString(), Optional.empty()));
    }

    @Test
    public void verifyBadSignatureOperation() {
        PublicJsonWebKey publicKey = (PublicJsonWebKey)Mockito.mock(PublicJsonWebKey.class);
        Mockito.when((Object)publicKey.getPublicKey()).thenReturn((Object)((PublicKey)Mockito.mock(PublicKey.class)));
        BaseTokenSigningAndEncryptionService service = (BaseTokenSigningAndEncryptionService)Mockito.mock(BaseTokenSigningAndEncryptionService.class);
        Mockito.when((Object)service.getJsonWebKeySigningKey()).thenReturn((Object)publicKey);
        Mockito.when((Object)service.decode(Mockito.anyString(), (Optional)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)service.verifySignature(Mockito.anyString(), (PublicJsonWebKey)Mockito.any())).thenReturn(null);
        Assertions.assertThrows(NullPointerException.class, () -> service.decode(UUID.randomUUID().toString(), Optional.empty()));
    }
}

