/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apereo.cas.ticket.BaseOAuth20ExpirationPolicyTests;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.logout.remove-descendant-tickets=true"})
@Tag(value="OAuthToken")
public class OAuth20AccessTokenExpirationPolicyTests
extends BaseOAuth20ExpirationPolicyTests {
    @Test
    public void verifyAccessTokenExpiryWhenTgtIsExpired() {
        TicketGrantingTicket tgt = OAuth20AccessTokenExpirationPolicyTests.newTicketGrantingTicket();
        OAuth20AccessToken at = this.newAccessToken(tgt);
        Assertions.assertFalse((boolean)at.isExpired(), (String)"Access token should not be expired");
        tgt.markTicketExpired();
        Assertions.assertTrue((boolean)at.isExpired(), (String)"Access token should not be expired when TGT is expired");
    }

    @Test
    public void verifyAccessTokenExpiredAfterSystemTime() {
        TicketGrantingTicketAwareTicket ticket = (TicketGrantingTicketAwareTicket)Mockito.mock(TicketGrantingTicketAwareTicket.class);
        Mockito.when((Object)ticket.getCreationTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusDays(10L));
        OAuth20AccessTokenExpirationPolicy exp = new OAuth20AccessTokenExpirationPolicy(100L, 100L);
        Assertions.assertTrue((boolean)exp.isExpired(ticket));
    }

    @Test
    public void verifyAccessTokenExpiredAfterTimeToKill() {
        TicketGrantingTicketAwareTicket ticket = (TicketGrantingTicketAwareTicket)Mockito.mock(TicketGrantingTicketAwareTicket.class);
        Mockito.when((Object)ticket.getCreationTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)ticket.getLastTimeUsed()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusDays(10L));
        OAuth20AccessTokenExpirationPolicy exp = new OAuth20AccessTokenExpirationPolicy(100L, 100L);
        Assertions.assertTrue((boolean)exp.isExpired(ticket));
    }

    @Test
    public void verifySerializeAnOAuthAccessTokenExpirationPolicyToJson() throws Exception {
        OAuth20AccessTokenExpirationPolicy policyWritten = new OAuth20AccessTokenExpirationPolicy(1234L, 5678L);
        MAPPER.writeValue(JSON_FILE, (Object)policyWritten);
        OAuth20AccessTokenExpirationPolicy policyRead = (OAuth20AccessTokenExpirationPolicy)MAPPER.readValue(JSON_FILE, OAuth20AccessTokenExpirationPolicy.class);
        Assertions.assertEquals((Object)policyWritten, (Object)policyRead);
    }
}

