/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import org.apereo.cas.ticket.BaseOAuth20ExpirationPolicyTests;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.logout.removeDescendantTickets=false"})
@Tag(value="OAuthToken")
public class OAuth20AccessTokenSovereignExpirationPolicyTests
extends BaseOAuth20ExpirationPolicyTests {
    @Test
    public void verifyAccessTokenExpiryWhenTgtIsExpired() {
        TicketGrantingTicket tgt = OAuth20AccessTokenSovereignExpirationPolicyTests.newTicketGrantingTicket();
        OAuth20AccessToken at = this.newAccessToken(tgt);
        Assertions.assertFalse((boolean)at.isExpired(), (String)"Access token must not be expired");
        tgt.markTicketExpired();
        Assertions.assertFalse((boolean)at.isExpired(), (String)"Access token must not be expired when TGT is expired");
    }
}

