/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.util.Set;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20DefaultAccessTokenFactoryTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperationCreate() {
        OAuthRegisteredService registeredService = OAuth20DefaultAccessTokenFactoryTests.getRegisteredService("https://app.oauth.org", "clientid-at", "secret-at");
        registeredService.setAccessTokenExpirationPolicy((RegisteredServiceOAuthAccessTokenExpirationPolicy)new DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy("PT10S", "PT10S"));
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20AccessToken token = this.defaultAccessTokenFactory.create((Service)RegisteredServiceTestUtils.getService((String)"https://app.oauth.org"), RegisteredServiceTestUtils.getAuthentication(), Set.of("Scope1", "Scope2"), "clientid-at", OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        Assertions.assertNotNull((Object)token);
        Assertions.assertNotNull((Object)this.defaultAccessTokenFactory.get(OAuth20AccessToken.class));
    }
}

