/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.util.Date;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.token.JwtBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20JwtBuilderTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyJwt() {
        this.servicesManager.save((RegisteredService)OAuth20JwtBuilderTests.getRegisteredService("clientid-jwt", "secret-jwt"));
        Service service = CoreAuthenticationTestUtils.getService((String)"https://service.example.com");
        JwtBuilder.JwtRequest request = JwtBuilder.JwtRequest.builder().issueDate(new Date()).jwtId(service.getId()).serviceAudience("clientid-jwt").subject("casuser").issuer(this.casProperties.getServer().getPrefix()).build();
        String jwt = this.accessTokenJwtBuilder.build(request);
        Assertions.assertNotNull((Object)jwt);
    }

    @Test
    public void verifyBadJwt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JwtBuilder.parse((String)"badly-formatted-jwt"));
    }
}

