/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import java.util.Map;
import java.util.Set;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthCodeExpirationPolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthCodeExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20DefaultOAuthCodeFactoryTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperationWithExpPolicy() {
        OAuthRegisteredService registeredService = OAuth20DefaultOAuthCodeFactoryTests.getRegisteredService("https://code.oauth.org", "clientid-code", "secret-at");
        registeredService.setCodeExpirationPolicy((RegisteredServiceOAuthCodeExpirationPolicy)new DefaultRegisteredServiceOAuthCodeExpirationPolicy(10L, "PT10S"));
        this.servicesManager.save((RegisteredService)registeredService);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        OAuth20Code token = this.defaultOAuthCodeFactory.create((Service)RegisteredServiceTestUtils.getService((String)"https://code.oauth.org"), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)tgt, Set.of("Scope1", "Scope2"), "code-challenge", "plain", "clientid-code", Map.of(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((boolean)tgt.getDescendantTickets().stream().anyMatch(t -> t.equalsIgnoreCase(token.getId())));
    }

    @Test
    public void verifyOperationWithoutExpPolicy() {
        OAuthRegisteredService registeredService = OAuth20DefaultOAuthCodeFactoryTests.getRegisteredService("https://noexp.oauth.org", "clientid-code-noexp", "secret-at");
        this.servicesManager.save((RegisteredService)registeredService);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        OAuth20Code token = this.defaultOAuthCodeFactory.create((Service)RegisteredServiceTestUtils.getService((String)"https://noexp.oauth.org"), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)tgt, Set.of("Scope1", "Scope2"), "code-challenge", "plain", "clientid-code-noexp", Map.of(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        Assertions.assertNotNull((Object)token);
        Assertions.assertNotNull((Object)this.defaultAccessTokenFactory.get(OAuth20Code.class));
        Assertions.assertTrue((boolean)tgt.getDescendantTickets().stream().anyMatch(t -> t.equalsIgnoreCase(token.getId())));
    }
}

