/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import java.util.List;
import java.util.UUID;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenUtils;
import org.apereo.cas.ticket.expiration.builder.TicketGrantingTicketExpirationPolicyBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20DeviceTokenUtilsTests
extends AbstractOAuth20Tests {
    @Override
    @BeforeEach
    public void setup() {
        super.setup();
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyDefault() {
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)UUID.randomUUID().toString());
        OAuthRegisteredService registeredService = OAuth20DeviceTokenUtilsTests.getRegisteredService(service.getId(), UUID.randomUUID().toString(), "secret");
        registeredService.setDeviceTokenExpirationPolicy(null);
        this.servicesManager.save((RegisteredService)registeredService);
        TicketGrantingTicketExpirationPolicyBuilder builder = new TicketGrantingTicketExpirationPolicyBuilder(this.casProperties);
        ExpirationPolicy policy = OAuth20DeviceTokenUtils.determineExpirationPolicyForService((ServicesManager)this.servicesManager, (ExpirationPolicyBuilder)builder, (Service)service);
        Assertions.assertEquals((long)28800L, (Long)policy.getTimeToLive());
    }

    @Test
    public void verifyCustom() {
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
        service.getAttributes().clear();
        OAuthRegisteredService registeredService = OAuth20DeviceTokenUtilsTests.getRegisteredService(service.getId(), UUID.randomUUID().toString(), "secret");
        service.getAttributes().put("client_id", List.of(registeredService.getClientId()));
        registeredService.setDeviceTokenExpirationPolicy((RegisteredServiceOAuthDeviceTokenExpirationPolicy)new DefaultRegisteredServiceOAuthDeviceTokenExpirationPolicy("PT60S"));
        this.servicesManager.save((RegisteredService)registeredService);
        TicketGrantingTicketExpirationPolicyBuilder builder = new TicketGrantingTicketExpirationPolicyBuilder(this.casProperties);
        ExpirationPolicy policy = OAuth20DeviceTokenUtils.determineExpirationPolicyForService((ServicesManager)this.servicesManager, (ExpirationPolicyBuilder)builder, (Service)service);
        Assertions.assertEquals((long)60L, (Long)policy.getTimeToLive());
    }
}

