/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import java.util.Map;
import java.util.Set;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuthToken")
public class OAuth20DefaultRefreshTokenFactoryTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyOperationWithExpPolicy() {
        OAuthRegisteredService registeredService = OAuth20DefaultRefreshTokenFactoryTests.getRegisteredService("https://rt.oauth.org", "clientid-rt", "secret-at");
        registeredService.setRefreshTokenExpirationPolicy((RegisteredServiceOAuthRefreshTokenExpirationPolicy)new DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy("PT100S"));
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20RefreshToken token = this.oAuthRefreshTokenFactory.create((Service)RegisteredServiceTestUtils.getService((String)"https://rt.oauth.org"), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), Set.of("Scope1", "Scope2"), "clientid-rt", "at-1234567890", Map.of(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        Assertions.assertNotNull((Object)token);
        Assertions.assertNotNull((Object)this.defaultAccessTokenFactory.get(OAuth20RefreshToken.class));
    }
}

