/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import org.apereo.cas.ticket.BaseOAuth20ExpirationPolicyTests;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.logout.remove-descendant-tickets=true"})
@Tag(value="OAuthToken")
public class OAuth20RefreshTokenExpirationPolicyTests
extends BaseOAuth20ExpirationPolicyTests {
    @Test
    public void verifyRefreshTokenExpiryWhenTgtIsExpired() {
        TicketGrantingTicket tgt = OAuth20RefreshTokenExpirationPolicyTests.newTicketGrantingTicket();
        OAuth20AccessToken at = this.newAccessToken(tgt);
        OAuth20RefreshToken rt = this.newRefreshToken(at);
        Assertions.assertFalse((boolean)rt.isExpired(), (String)"Refresh token should not be expired");
        tgt.markTicketExpired();
        Assertions.assertTrue((boolean)rt.isExpired(), (String)"Refresh token should not be expired when TGT is expired");
        Assertions.assertEquals((long)0L, (Long)rt.getExpirationPolicy().getTimeToIdle());
    }

    @Test
    public void verifyFails() {
        TicketGrantingTicket tgt = OAuth20RefreshTokenExpirationPolicyTests.newTicketGrantingTicket();
        OAuth20AccessToken at = this.newAccessToken(tgt);
        OAuth20RefreshToken rt = this.newRefreshToken(at);
        Assertions.assertTrue((boolean)rt.getExpirationPolicy().isExpired(null));
    }

    @Test
    public void verifySerializeAnOAuthRefreshTokenExpirationPolicyToJson() throws Exception {
        OAuth20RefreshTokenExpirationPolicy policyWritten = new OAuth20RefreshTokenExpirationPolicy(1234L);
        MAPPER.writeValue(JSON_FILE, (Object)policyWritten);
        OAuth20RefreshTokenExpirationPolicy policyRead = (OAuth20RefreshTokenExpirationPolicy)MAPPER.readValue(JSON_FILE, OAuth20RefreshTokenExpirationPolicy.class);
        Assertions.assertEquals((Object)policyWritten, (Object)policyRead);
    }
}

