/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import org.apereo.cas.ticket.BaseOAuth20ExpirationPolicyTests;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OAuthToken")
@TestPropertySource(properties={"cas.logout.removeDescendantTickets=false"})
public class OAuth20RefreshTokenSovereignExpirationPolicyTests
extends BaseOAuth20ExpirationPolicyTests {
    @Test
    public void verifyRefreshTokenExpiryWhenTgtIsExpired() {
        TicketGrantingTicket tgt = OAuth20RefreshTokenSovereignExpirationPolicyTests.newTicketGrantingTicket();
        OAuth20AccessToken at = this.newAccessToken(tgt);
        OAuth20RefreshToken rt = this.newRefreshToken(at);
        Assertions.assertFalse((boolean)rt.isExpired(), (String)"Refresh token should not be expired");
        tgt.markTicketExpired();
        Assertions.assertFalse((boolean)rt.isExpired(), (String)"Refresh token must not expired when TGT is expired");
    }
}

