/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasOAuth20AuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasOAuth20Configuration;
import org.apereo.cas.config.CasOAuth20EndpointsConfiguration;
import org.apereo.cas.config.CasOAuth20ThrottleConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasRegisteredServicesTestConfiguration;
import org.apereo.cas.config.CasThrottlingConfiguration;
import org.apereo.cas.config.CasThymeleafConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.config.OidcComponentSerializationConfiguration;
import org.apereo.cas.oidc.config.OidcConfiguration;
import org.apereo.cas.oidc.config.OidcEndpointsConfiguration;
import org.apereo.cas.oidc.config.OidcLogoutConfiguration;
import org.apereo.cas.oidc.config.OidcResponseConfiguration;
import org.apereo.cas.oidc.config.OidcThrottleConfiguration;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.webflow.execution.Action;

@SpringBootTest(classes={SharedTestConfiguration.class}, properties={"spring.main.allow-bean-definition-overriding=true", "cas.authn.oidc.core.issuer=https://sso.example.org/cas/oidc", "cas.authn.oidc.jwks.jwks-file=classpath:keystore.jwks"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public abstract class AbstractOidcTests {
    protected static final String TGT_ID = "TGT-0";
    @Autowired
    @Qualifier(value="oidcMultifactorAuthenticationTrigger")
    protected MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger;
    @Autowired
    @Qualifier(value="oidcIssuerService")
    protected OidcIssuerService oidcIssuerService;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    protected SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder;
    protected ConfigurableApplicationContext applicationContext;
    @Autowired
    protected ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="oauthInterceptor")
    protected HandlerInterceptor oauthInterceptor;
    @Autowired
    @Qualifier(value="oidcWebFingerDiscoveryService")
    protected OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService;
    @Autowired
    @Qualifier(value="oidcImplicitIdTokenAndTokenCallbackUrlBuilder")
    protected OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenAndTokenCallbackUrlBuilder;
    @Autowired
    @Qualifier(value="oidcImplicitIdTokenCallbackUrlBuilder")
    protected OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder;
    @Autowired
    @Qualifier(value="oidcRegisteredServiceJwtAccessTokenCipherExecutor")
    protected RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor;
    @Autowired
    @Qualifier(value="oidcAccessTokenJwtCipherExecutor")
    protected CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor;
    @Autowired
    @Qualifier(value="oidcUserProfileViewRenderer")
    protected OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer;
    @Autowired
    @Qualifier(value="defaultDeviceTokenFactory")
    protected OAuth20DeviceTokenFactory deviceTokenFactory;
    @Autowired
    @Qualifier(value="defaultDeviceUserCodeFactory")
    protected OAuth20DeviceUserCodeFactory deviceUserCodeFactory;
    @Autowired
    @Qualifier(value="oidcUserProfileDataCreator")
    protected OAuth20UserProfileDataCreator oidcUserProfileDataCreator;
    @Autowired
    @Qualifier(value="oauthCasClientRedirectActionBuilder")
    protected OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder;
    @Autowired
    @Qualifier(value="profileScopeToAttributesFilter")
    protected OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
    @Autowired
    @Qualifier(value="oidcUserProfileSigningAndEncryptionService")
    protected OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService;
    @Autowired
    @Qualifier(value="oidcServiceRegistryListener")
    protected ServiceRegistryListener oidcServiceRegistryListener;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    protected OAuth20CodeFactory defaultOAuthCodeFactory;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    protected ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="callbackAuthorizeViewResolver")
    protected OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver;
    @Autowired
    protected CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="oidcDefaultJsonWebKeystoreCache")
    protected LoadingCache<String, Optional<PublicJsonWebKey>> oidcDefaultJsonWebKeystoreCache;
    @Autowired
    @Qualifier(value="oidcTokenSigningAndEncryptionService")
    protected OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService;
    @Autowired
    @Qualifier(value="oidcServiceJsonWebKeystoreCache")
    protected LoadingCache<OAuthRegisteredService, Optional<PublicJsonWebKey>> oidcServiceJsonWebKeystoreCache;
    @Autowired
    @Qualifier(value="oidcJsonWebKeystoreGeneratorService")
    protected OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    protected AuditableExecution registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oidcRegisteredServiceUIAction")
    protected Action oidcRegisteredServiceUIAction;
    @Autowired
    @Qualifier(value="oidcServerDiscoverySettingsFactory")
    protected OidcServerDiscoverySettings oidcServerDiscoverySettings;
    @Autowired
    @Qualifier(value="oidcAccessTokenResponseGenerator")
    protected OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator;
    @Autowired
    @Qualifier(value="oidcAttributeToScopeClaimMapper")
    protected OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper;
    @Autowired
    @Qualifier(value="ticketRegistry")
    protected TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="oidcIdTokenGenerator")
    protected IdTokenGeneratorService oidcIdTokenGenerator;
    @Autowired
    @Qualifier(value="consentApprovalViewResolver")
    protected ConsentApprovalViewResolver consentApprovalViewResolver;
    @Autowired
    @Qualifier(value="accessTokenJwtBuilder")
    protected JwtBuilder oidcAccessTokenJwtBuilder;
    @Autowired
    @Qualifier(value="accessTokenExpirationPolicy")
    protected ExpirationPolicyBuilder accessTokenExpirationPolicy;

    protected static OidcRegisteredService getOidcRegisteredService() {
        return AbstractOidcTests.getOidcRegisteredService(true, true);
    }

    protected static OidcRegisteredService getOidcRegisteredService(boolean sign, boolean encrypt) {
        return AbstractOidcTests.getOidcRegisteredService("clientid", "https://oauth\\.example\\.org.*", sign, encrypt);
    }

    protected static OidcRegisteredService getOidcRegisteredService(String clientid, String redirectUri) {
        return AbstractOidcTests.getOidcRegisteredService(clientid, redirectUri, true, true);
    }

    protected static OidcRegisteredService getOidcRegisteredService(String clientid) {
        return AbstractOidcTests.getOidcRegisteredService(clientid, "https://oauth\\.example\\.org.*", true, true);
    }

    protected static OidcRegisteredService getOidcRegisteredService(String clientId, String redirectUri, boolean sign, boolean encrypt) {
        OidcRegisteredService svc = new OidcRegisteredService();
        svc.setClientId(clientId);
        svc.setName("oauth");
        svc.setDescription("description");
        svc.setClientSecret("secret");
        svc.setServiceId(redirectUri);
        svc.setSignIdToken(sign);
        svc.setEncryptIdToken(encrypt);
        svc.setIdTokenEncryptionAlg("RSA-OAEP-256");
        svc.setIdTokenEncryptionEncoding("A128CBC-HS256");
        svc.setInformationUrl("info");
        svc.setPrivacyUrl("privacy");
        svc.setJwks("classpath:keystore.jwks");
        svc.setLogoutUrl("https://oauth.example.org/logout,https://logout,https://www.acme.com/.*");
        svc.setLogoutType(RegisteredServiceLogoutType.BACK_CHANNEL);
        svc.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope()}));
        return svc;
    }

    protected static OAuthRegisteredService getOAuthRegisteredService(String clientId, String redirectUri) {
        OAuthRegisteredService svc = new OAuthRegisteredService();
        svc.setClientId(clientId);
        svc.setName("oauth");
        svc.setDescription("description");
        svc.setClientSecret("secret");
        svc.setServiceId(redirectUri);
        svc.setInformationUrl("info");
        svc.setPrivacyUrl("privacy");
        return svc;
    }

    protected static OAuth20RefreshToken getRefreshToken() {
        Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"email", List.of("casuser@example.org")));
        OAuth20RefreshToken token = (OAuth20RefreshToken)Mockito.mock(OAuth20RefreshToken.class);
        Mockito.when((Object)token.getAuthentication()).thenReturn((Object)RegisteredServiceTestUtils.getAuthentication((Principal)principal));
        Mockito.when((Object)token.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService((String)"https://oauth.example.org"));
        Mockito.when((Object)token.getId()).thenReturn((Object)"RT-123456");
        Mockito.when((Object)token.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)token.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.OPENID.getScope()));
        Mockito.when((Object)token.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return token;
    }

    protected static MockHttpServletRequest getHttpRequestForEndpoint(String endpoint) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("sso.example.org");
        request.setServerPort(443);
        request.setRequestURI("/cas/oidc/" + endpoint);
        return request;
    }

    @BeforeEach
    public void initialize() {
        this.applicationContext = new StaticApplicationContext();
        this.applicationContext.refresh();
        ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, (Object)this.casProperties, (String)CasConfigurationProperties.class.getSimpleName());
        ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, (Object)this.oidcAttributeToScopeClaimMapper, (String)"oidcAttributeToScopeClaimMapper");
        ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
        this.servicesManager.save((RegisteredService)AbstractOidcTests.getOidcRegisteredService());
        this.ticketRegistry.deleteAll();
    }

    protected JwtClaims getClaims() {
        return this.getClaims(AbstractOidcTests.getOidcRegisteredService().getClientId());
    }

    protected JwtClaims getClaims(String clientId) {
        return this.getClaims("casuser", this.casProperties.getAuthn().getOidc().getCore().getIssuer(), clientId, clientId);
    }

    protected JwtClaims getClaims(String subject, String issuer, String clientId, String audience) {
        JwtClaims claims = new JwtClaims();
        claims.setJwtId(RandomUtils.randomAlphanumeric((int)16));
        claims.setIssuer(issuer);
        claims.setAudience(audience);
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(120L);
        claims.setExpirationTime(expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast(1.0f);
        claims.setSubject(subject);
        claims.setStringClaim("client_id", clientId);
        return claims;
    }

    protected OAuth20AccessToken getAccessToken() {
        return this.getAccessToken("", "clientId");
    }

    protected OAuth20AccessToken getAccessToken(String clientId) {
        return this.getAccessToken("", clientId);
    }

    protected OAuth20AccessToken getAccessToken(String idToken, String clientId) {
        Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"email", List.of("casuser@example.org")));
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)AbstractOidcTests.getOidcRegisteredService());
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)RegisteredServiceTestUtils.getAuthentication((Principal)principal));
        Mockito.when((Object)accessToken.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService((String)"https://oauth.example.org"));
        Mockito.when((Object)accessToken.getId()).thenReturn((Object)("AT-" + UUID.randomUUID()));
        Mockito.when((Object)accessToken.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getClientId()).thenReturn((Object)clientId);
        Mockito.when((Object)accessToken.getCreationTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.OPENID.getScope()));
        Mockito.when((Object)accessToken.getToken()).thenReturn((Object)code.getId());
        Mockito.when((Object)accessToken.getIdToken()).thenReturn((Object)idToken);
        return accessToken;
    }

    protected OAuth20Code addCode(Principal principal, OAuthRegisteredService registeredService) {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication((Principal)principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getClientId());
        OAuth20Code code = this.defaultOAuthCodeFactory.create((Service)service, authentication, (TicketGrantingTicket)tgt, new ArrayList(), null, null, "clientid", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        return code;
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, SecurityAutoConfiguration.class, WebMvcAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebflowConfiguration.class, CasCoreWebConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreHttpConfiguration.class, CasCoreAuditConfiguration.class, CasCoreLogoutConfiguration.class, CasWebflowContextConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasRegisteredServicesTestConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCookieConfiguration.class, CasThemesConfiguration.class, CasThymeleafConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasOAuth20Configuration.class, CasOAuth20EndpointsConfiguration.class, CasThrottlingConfiguration.class, CasOAuth20ThrottleConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasOAuth20AuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, OidcConfiguration.class, OidcEndpointsConfiguration.class, OidcResponseConfiguration.class, OidcLogoutConfiguration.class, OidcThrottleConfiguration.class, OidcComponentSerializationConfiguration.class})
    public static class SharedTestConfiguration {
    }
}

