/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcAccessTokenAuthenticatorTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        String token = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)OidcAccessTokenAuthenticatorTests.getOidcRegisteredService(), this.getClaims());
        OidcAccessTokenAuthenticator auth = new OidcAccessTokenAuthenticator(this.ticketRegistry, this.oidcTokenSigningAndEncryptionService, this.servicesManager, this.oidcAccessTokenJwtBuilder);
        OAuth20AccessToken at = this.getAccessToken(token, "clientid");
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        auth.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNotNull((Object)userProfile);
        Assertions.assertEquals((Object)"casuser", (Object)userProfile.getId());
        Assertions.assertTrue((boolean)userProfile.containsAttribute("client_id"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("sub"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("iss"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("exp"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("aud"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("email"));
        Assertions.assertEquals(OAuth20AccessToken.class, (Object)this.accessTokenExpirationPolicy.getTicketType());
    }

    @Test
    public void verifyFailsOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        OidcAccessTokenAuthenticator auth = new OidcAccessTokenAuthenticator(this.ticketRegistry, this.oidcTokenSigningAndEncryptionService, this.servicesManager, this.oidcAccessTokenJwtBuilder);
        OAuth20AccessToken at = this.getAccessToken("helloworld", "clientid");
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        auth.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }
}

