/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcClientConfigurationAccessTokenAuthenticatorTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        OidcClientConfigurationAccessTokenAuthenticator auth = new OidcClientConfigurationAccessTokenAuthenticator(this.ticketRegistry, this.oidcAccessTokenJwtBuilder);
        OAuth20AccessToken at = this.getAccessToken();
        Mockito.when((Object)at.getScopes()).thenReturn(Set.of("ClientRegistrationScope"));
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        auth.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNotNull((Object)userProfile);
        Assertions.assertEquals((Object)"casuser", (Object)userProfile.getId());
    }

    @Test
    public void verifyFailsOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        OidcClientConfigurationAccessTokenAuthenticator auth = new OidcClientConfigurationAccessTokenAuthenticator(this.ticketRegistry, this.oidcAccessTokenJwtBuilder);
        OAuth20AccessToken at = this.getAccessToken();
        Mockito.when((Object)at.getScopes()).thenThrow(new Throwable[]{new IllegalArgumentException()});
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        auth.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNull((Object)userProfile);
    }
}

